/*----------------------------------------------------------------------------
 * Thread and Thread Var Definitions
 *---------------------------------------------------------------------------*/
#define KM_MCODE_HANDLER_THREAD		4
#define	KM_MCODE_HANDLER_VAR		((KM_MCODE_HANDLER_THREAD * 3) - 2)
#define	KM_MCODE_PPARAM				KM_MCODE_HANDLER_VAR
#define	KM_MCODE_QPARAM				(KM_MCODE_PPARAM + 1)
#define	KM_MCODE_RPARAM				(KM_MCODE_QPARAM + 1)

/*----------------------------------------------------------------------------
 * Miscellaneous Definitions
 *---------------------------------------------------------------------------*/
#define AXIS_X				0
#define AXIS_Y				1
#define AXIS_Z				2
#define AXIS_A				3

/*----------------------------------------------------------------------------
 * Homing and Probing Definitions
 *
 * All in real units (inch/mm)
 *---------------------------------------------------------------------------*/
#define HOME_PIN			0		// Home Switch input
#define PROBE_PIN			1		// PROBE input

/********************************************
 *	Probing and Homing Parameters
 *
 *******************************************/
#define FAST_HOME_SPEED			30.0	// Fast Home Velocity
#define SLOW_HOME_SPEED			1.0		// Slow Home Velocity

#define FAST_PROBE_SPEED		5.0		// Fast Probe Velocity
#define SLOW_PROBE_SPEED		1.0		// Slow Probe Velocity

#define PROBE_DISTANCE			0.5		// Maximum Probe Distance
#define PROBE_BACK_OFF			0.125	// Probe Back-off Distance
#define TOUCHPLATE_THICKNESS		0.0625	// Probe Touchplate Thickness


/*----------------------------------------------------------------------------
 * Limit Switch Configuration Options
 *---------------------------------------------------------------------------*/
#define LIMIT_STOP_ON_NEG		0x1
#define LIMIT_STOP_ON_POS		0x2
#define LIMIT_NEG_ACTIVE_LOW		0x4
#define LIMIT_POS_ACTIVE_LOW		0x8
#define LIMIT_KILL_MOTOR_DRIVE		0x0
#define LIMIT_DISALLOW_DRIVE		0x10
#define LIMIT_STOP_MOVEMENT		0x20
#define LIMIT_OVERRIDE			0x1000
#define LIMIT_IGNORE			0x2000
#define LIMIT_IN_LIMIT			0x8000
#define LIMIT_NEG_LIMIT_BIT(x)	((x) << 16)
#define LIMIT_POS_LIMIT_BIT(x)	((x) << 24)
