﻿/*
Copyright © 2011 Brad Murry
All rights reserved.

BSD License:

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:
Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, 
OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, 
OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace MachineUtil
{
    public class BitNode
    {
        bool _ReverseSegments = false;
        bool[] _Data;
        int _Start = 0;
        public bool ReverseSegments
        {
            get
            {
                return _ReverseSegments;
            }
            set
            {
                _ReverseSegments = value;
            }
        }
        public bool[] Data
        {
            get
            {
                return _Data;
            }
        }

        public BitNode(int size)
        {
            _Start = size - 1;
            _Data = new bool[size];
            for (int i = 0; i < size; i++)
            {
                _Data[i] = false;
            }
        }

        public BitNode(int size, bool reversesegments)
        {
            _Start = size - 1;
            _ReverseSegments = reversesegments;
            _Data = new bool[size];
            for (int i = 0; i < size; i++)
            {
                _Data[i] = false;
            }
        }


        public void SetBit(int index, bool value)
        {
            if (_Start - index > 0)
            {
                _Data[_Start - index] = value;
            }
            else
            {
                throw new Exception("Attempted to set a bit outside the bounds of the Node");
            }
        }

        public bool GetBit(int index)
        {
            if (_Start - index > 0)
            {
                return _Data[_Start - index];
            }
            else
            {
                throw new Exception("Attempted to get a bit outside the bounds of the Node");
            }
        }



        public void SetBits(int start, string value)
        {
            if (_ReverseSegments)
            {
                char[] charArray = value.ToCharArray();
                Array.Reverse(charArray);
                value = new string(charArray);
            }
            for (int i = 0; i < value.Length; i++)
            {
                var idx = _Start - start - i;
                if (idx > -1 && idx < _Data.Length)
                {
                    if (value[i] == '1')
                    {
                        _Data[_Start - start - i] = true;
                    }
                    else
                    {
                        _Data[_Start - start - i] = false;
                    }
                }
            }
        }

        public void SetBits(int start, int value)
        {
            var val = Convert.ToString((short)value, 2);
            SetBits(start, val);
        }

        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < _Data.Length; i++)
            {
                sb.Append(_Data[i] == true ? 1 : 0);
            }
            return String.Format("BitNode({0})", sb.ToString());
        }
        public string ToLRString()
        {
            StringBuilder sb = new StringBuilder();
            for (int i = _Start; i > -1; i--)
            {
                sb.Append(_Data[i] == true ? 1 : 0);
            }
            return String.Format("BitNode({0})", sb.ToString());
        }

        public string ToBinary()
        {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < _Data.Length; i++)
            {
                sb.Append(_Data[i] == true ? 1 : 0);
            }
            return sb.ToString();
        }
        public string ToLRBinary()
        {
            StringBuilder sb = new StringBuilder();
            for (int i = _Start; i > -1; i--)
            {
                sb.Append(_Data[i] == true ? 1 : 0);
            }
            return sb.ToString();
        }

        public int ToInt()
        {
            return Convert.ToInt32(ToBinary(), 2);
        }

        public string ToHex()
        {
            return Convert.ToInt32(ToBinary(), 2).ToString("X");
        }

        public string ToHex2()
        {
            return String.Format("0x{0:X}", Convert.ToInt32(ToBinary(), 2));
        }
    }
}
