#include "KMotionDef.h"

// Configuration and Homing program for a 2 axis System
// Limit switches are disabled and used as a home switch
// then they are re-enabled

#define X 0
#define Y 1

#define HOME_SPEED 2750
#define HOME_BACKOUT 400

#define XLIMIT_PLUS  0
#define XLIMIT_MINUS 1
#define YLIMIT_PLUS  2
#define YLIMIT_MINUS 3

#define LIMIT_ACTIVE   0
#define LIMIT_INACTIVE 1

main()
{
	int SaveXLimits,SaveYLimits;  	//place to save limit switch settings

	int flags = persist.UserData[5];  // Mach3 flags bit0=X, bit1=Y, Bit2=Z, etc...

	printf("Mach3 Home Call flags = %d\n",flags); 

	/*
	DisableAxis(X);  // Disable all axes
	DisableAxis(Y);

	// Set the axis parameters here
	// after everything is configured in the KMotion Screens
	// use copy C Code to clipboard on the configuration screen
	// then paste here.  Repeat for each axis
	// disable the limits (first save how they were set) 
	SaveXLimits = ch0->LimitSwitchOptions;
	SaveYLimits = ch1->LimitSwitchOptions;
	ch0->LimitSwitchOptions = 0;
	ch1->LimitSwitchOptions = 0;
	
	// enable all 2 axes and begin servoing where we are 
	
	EnableAxis(X);
	EnableAxis(Y);
	*/
	
	
	if (flags & 1)
	{
		printf("Homing X now\n");
		DisableAxis(X);  // Disable all axes
		SaveXLimits = ch0->LimitSwitchOptions;
		ch0->LimitSwitchOptions = 0;
		// enable X Axis and begin servoing where we are 
		EnableAxis(X);

		Jog(X,-HOME_SPEED);  			// jog home negative
		while (ReadBit(XLIMIT_MINUS) == LIMIT_INACTIVE) ;  // loop until IO bit goes Inactive
		Jog(X,0);				// stop
		while (!CheckDone(X)) ; // loop until motion completes 
		printf("Find X now and backing out\n");
		Jog(X, HOME_BACKOUT);
		while (ReadBit(XLIMIT_MINUS) == LIMIT_ACTIVE);	// loop until IO bit goes Active
		Jog(X,0);
		while (!CheckDone(X));
		DisableAxis(X);			// disable the axis
		Zero(X);				// Zero the position
		EnableAxis(X);			// re-enable the ServoTick
		ch0->LimitSwitchOptions = SaveXLimits;  // restore limit settings

		DefineCoordSystem(0,1,-1,-1);  //Define XYZ coordinated motion axes
		printf("Homing X Done\n");
	}


	// Home Y next - jog until it sees the limit
	if (flags & 2)
	{
		printf("Homing Y now\n");
		DisableAxis(Y);
		SaveYLimits = ch1->LimitSwitchOptions;
		ch1->LimitSwitchOptions = 0;
		// enable Y Axis and begin servoing where we are 
		EnableAxis(Y);
		
		Jog(Y,-HOME_SPEED);  			// jog slowly negative
		while (ReadBit(YLIMIT_MINUS) == LIMIT_INACTIVE) ;  // loop until IO bit goes Inactive
		Jog(Y,0);				// stop
		while (!CheckDone(Y)) ; // loop until motion completes 
		printf("Find Y now and backing out\n");
		Jog(Y, HOME_BACKOUT);
		while (ReadBit(YLIMIT_MINUS) == LIMIT_ACTIVE);
		Jog(Y, 0);
		while (!CheckDone(Y));
		DisableAxis(Y);			// disable the axis
		Zero(Y);				// Zero the position
		EnableAxis(Y);			// re-enable the ServoTick
    
		ch1->LimitSwitchOptions = SaveYLimits;  // restore limit settings
		DefineCoordSystem(0,1,-1,-1);  //Define XYZ coordinated motion axes

		printf("Homing Y Done\n");
	}
}
