#include "KMotionDef.h"

// Home and set the commutation for two 3-phase brushless motors

// Assume index mark  

main() 
{
    float k=0,A=10.0f;   // set coil current amplitude PWM units
	double p0;
	
	WriteSnapAmp(SNAP0+SNAP_SUPPLY_CLAMP0 ,SNAP_CONVERT_VOLTS_TO_ADC(80.0));
	WriteSnapAmp(SNAP0+SNAP_SUPPLY_CLAMP1 ,SNAP_CONVERT_VOLTS_TO_ADC(80.0));
	
	WriteSnapAmp(SNAP0+SNAP_SUPPLY_CLAMP_ENA0,1);
	WriteSnapAmp(SNAP0+SNAP_SUPPLY_CLAMP_ENA1,1);
	
	WriteSnapAmp(SNAP0+SNAP_PEAK_CUR_LIMIT0,12);  // current limit (12 for BSM80C-375)
	WriteSnapAmp(SNAP0+SNAP_PEAK_CUR_LIMIT1,12);  // current limit
	
	Delay_sec(1);  // wait for any fault to clear
   	
	// rotate until we find the index mark for ch0

	ch0->Enable=FALSE;
	ch0->OutputChan0=8;
	for (;;)
    {
    	WaitNextTimeSlice();
		
		Write3PH(ch0,A, ++k/10000.0);  // move the pole 

		if (ReadBit(66))  // check for index mark
		{
			p0=ch0->Position; // save position
			ch0->Position=0;  // set current position to Zero
			
			ch0->CommutationOffset = 2875;
			
			printf("Position X axis = %f\n",p0);
			break;
		}
    }

	Write3PH(ch0,0,0);    // turn off the coil    

	// define the axis as 3 phase BRUSHLESS_3PH_MODE
	// and set low PID gains
	
	ch0->InputMode=ENCODER_MODE;
	ch0->OutputMode=BRUSHLESS_3PH_MODE;
	ch0->Vel=150000;
	ch0->Accel=1e+008;
	ch0->Jerk=1e+010;
	ch0->P=0.1;
	ch0->I=0;
	ch0->D=0;
	ch0->FFAccel=0;
	ch0->FFVel=0;
	ch0->MaxI=200;
	ch0->MaxErr=100000;
	ch0->MaxOutput=2000;
	ch0->DeadBandGain=1;
	ch0->DeadBandRange=0;
	ch0->InputChan0=8;
	ch0->InputChan1=4;
	ch0->OutputChan0=8;
	ch0->OutputChan1=9;
	ch0->MasterAxis=-1;
	ch0->LimitSwitchOptions=0x4b49001f;
	ch0->InputGain0=1;
	ch0->InputGain1=1;
	ch0->InputOffset0=0;
	ch0->InputOffset1=0;
	ch0->OutputGain=1;
	ch0->OutputOffset=0;
	ch0->SlaveGain=1;
	ch0->BacklashMode=BACKLASH_OFF;
	ch0->BacklashAmount=0;
	ch0->BacklashRate=0;
	ch0->invDistPerCycle=0.0002;
	ch0->Lead=0;
	ch0->MaxFollowingError=400000;
	ch0->StepperAmplitude=20;

	ch0->iir[0].B0=1;
	ch0->iir[0].B1=0;
	ch0->iir[0].B2=0;
	ch0->iir[0].A1=0;
	ch0->iir[0].A2=0;

	ch0->iir[1].B0=1;
	ch0->iir[1].B1=0;
	ch0->iir[1].B2=0;
	ch0->iir[1].A1=0;
	ch0->iir[1].A2=0;

	ch0->iir[2].B0=1;
	ch0->iir[2].B1=0;
	ch0->iir[2].B2=0;
	ch0->iir[2].A1=0;
	ch0->iir[2].A2=0;


	EnableAxisDest(0,ch0->Position);  // Enable ch0 servo where we currently are
	
		// rotate until we find the index mark for ch1

	ch1->Enable=FALSE;
	ch1->OutputChan0=10;
	for (;;)
    {
    	WaitNextTimeSlice();
		
		Write3PH(ch1,A, ++k/10000.0);  // move the pole 

		if (ReadBit(67))  // check for index mark
		{
			p0=ch1->Position; // save position
			ch1->Position=0;  // set current position to Zero
			
			ch1->CommutationOffset = -820;
			
			printf("Position Y axis = %f\n",p0);
			break;
		}
    }

	Write3PH(ch1,0,0);    // turn off the coil    

	// define the axis as 3 phase BRUSHLESS_3PH_MODE
	// and set low PID gains
	
	ch1->InputMode=ENCODER_MODE;
	ch1->OutputMode=BRUSHLESS_3PH_MODE;
	ch1->Vel=150000;
	ch1->Accel=1e+008;
	ch1->Jerk=1e+010;
	ch1->P=0.1;
	ch1->I=0;
	ch1->D=0;
	ch1->FFAccel=0;
	ch1->FFVel=0;
	ch1->MaxI=200;
	ch1->MaxErr=100000;
	ch1->MaxOutput=2000;
	ch1->DeadBandGain=1;
	ch1->DeadBandRange=0;
	ch1->InputChan0=10;
	ch1->InputChan1=4;
	ch1->OutputChan0=10;
	ch1->OutputChan1=9;
	ch1->MasterAxis=-1;
	ch1->LimitSwitchOptions=0x4a48001f;
	ch1->InputGain0=-1;
	ch1->InputGain1=1;
	ch1->InputOffset0=0;
	ch1->InputOffset1=0;
	ch1->OutputGain=1;
	ch1->OutputOffset=0;
	ch1->SlaveGain=1;
	ch1->BacklashMode=BACKLASH_OFF;
	ch1->BacklashAmount=0;
	ch1->BacklashRate=0;
	ch1->invDistPerCycle=0.0002;
	ch1->Lead=0;
	ch1->MaxFollowingError=400000;
	ch1->StepperAmplitude=20;

	ch1->iir[0].B0=1;
	ch1->iir[0].B1=0;
	ch1->iir[0].B2=0;
	ch1->iir[0].A1=0;
	ch1->iir[0].A2=0;

	ch1->iir[1].B0=1;
	ch1->iir[1].B1=0;
	ch1->iir[1].B2=0;
	ch1->iir[1].A1=0;
	ch1->iir[1].A2=0;

	ch1->iir[2].B0=1;
	ch1->iir[2].B1=0;
	ch1->iir[2].B2=0;
	ch1->iir[2].A1=0;
	ch1->iir[2].A2=0;

	
	EnableAxisDest(1,ch1->Position);  // Enable ch1 servo where we currently are
	
	DefineCoordSystem(0,1,-1,-1);
}
