#include "KMotionDef.h"

#define RTIFRC0     0x42000010 // free running counter

#define ESTOP 142

int Debounce(int n, int *cnt, int *last, int *lastsolid);
int flast=0,flastsolid=-1,fcount=0;

main()
{
	ch0->InputMode=NO_INPUT_MODE;
	ch0->OutputMode=STEP_DIR_MODE;
	ch0->Vel=5000;
	ch0->Accel=5e+005;
	ch0->Jerk=5e+007;
	ch0->P=0.05;
	ch0->I=0;
	ch0->D=0;
	ch0->FFAccel=0;
	ch0->FFVel=0;
	ch0->MaxI=2000;
	ch0->MaxErr=1e+008;
	ch0->MaxOutput=2000;
	ch0->DeadBandGain=1;
	ch0->DeadBandRange=0;
	ch0->InputChan0=0;
	ch0->InputChan1=1;
	ch0->OutputChan0=12; // 28 is quadrature
	ch0->OutputChan1=1;
	ch0->MasterAxis=-1;
	ch0->LimitSwitchOptions=0x11f;
	ch0->LimitSwitchNegBit=136;
	ch0->LimitSwitchPosBit=137;
	ch0->SoftLimitPos=1e+030;
	ch0->SoftLimitNeg=-1e+030;
	ch0->InputGain0=1;
	ch0->InputGain1=1;
	ch0->InputOffset0=0;
	ch0->InputOffset1=0;
	ch0->OutputGain=-1;
	ch0->OutputOffset=0;
	ch0->SlaveGain=1;
	ch0->BacklashMode=BACKLASH_OFF;
	ch0->BacklashAmount=0;
	ch0->BacklashRate=0;
	ch0->invDistPerCycle=409.5;
	ch0->Lead=0;
	ch0->MaxFollowingError=10000000;
	ch0->StepperAmplitude=250;

	ch0->iir[0].B0=1;
	ch0->iir[0].B1=0;
	ch0->iir[0].B2=0;
	ch0->iir[0].A1=0;
	ch0->iir[0].A2=0;

	ch0->iir[1].B0=1;
	ch0->iir[1].B1=0;
	ch0->iir[1].B2=0;
	ch0->iir[1].A1=0;
	ch0->iir[1].A2=0;

	ch0->iir[2].B0=1;
	ch0->iir[2].B1=0;
	ch0->iir[2].B2=0;
	ch0->iir[2].A1=0;
	ch0->iir[2].A2=0;
	EnableAxisDest(0,0);

	ch1->InputMode=NO_INPUT_MODE;
	ch1->OutputMode=STEP_DIR_MODE;
	ch1->Vel=5000;
	ch1->Accel=5e+005;
	ch1->Jerk=5e+007;
	ch1->P=0.05;
	ch1->I=0;
	ch1->D=0;
	ch1->FFAccel=0;
	ch1->FFVel=0;
	ch1->MaxI=2000;
	ch1->MaxErr=1e+008;
	ch1->MaxOutput=2000;
	ch1->DeadBandGain=1;
	ch1->DeadBandRange=0;
	ch1->InputChan0=0;
	ch1->InputChan1=1;
	ch1->OutputChan0=13; //29 is quadrature
	ch1->OutputChan1=1;
	ch1->MasterAxis=-1;
	ch1->LimitSwitchOptions=0x11f;
	ch1->LimitSwitchNegBit=138;
	ch1->LimitSwitchPosBit=139;
	ch1->SoftLimitPos=1e+009;
	ch1->SoftLimitNeg=-1e+009;
	ch1->InputGain0=1;
	ch1->InputGain1=1;
	ch1->InputOffset0=0;
	ch1->InputOffset1=0;
	ch1->OutputGain=-1;
	ch1->OutputOffset=0;
	ch1->SlaveGain=1;
	ch1->BacklashMode=BACKLASH_OFF;
	ch1->BacklashAmount=0;
	ch1->BacklashRate=0;
	ch1->invDistPerCycle=409.5;
	ch1->Lead=0;
	ch1->MaxFollowingError=10000000;
	ch1->StepperAmplitude=250;

	ch1->iir[0].B0=1;
	ch1->iir[0].B1=0;
	ch1->iir[0].B2=0;
	ch1->iir[0].A1=0;
	ch1->iir[0].A2=0;

	ch1->iir[1].B0=1;
	ch1->iir[1].B1=0;
	ch1->iir[1].B2=0;
	ch1->iir[1].A1=0;
	ch1->iir[1].A2=0;

	ch1->iir[2].B0=1;
	ch1->iir[2].B1=0;
	ch1->iir[2].B2=0;
	ch1->iir[2].A1=0;
	ch1->iir[2].A2=0;
	EnableAxisDest(1,0);
	
	ch2->InputMode=NO_INPUT_MODE;
	ch2->OutputMode=STEP_DIR_MODE;
	ch2->Vel=800;
	ch2->Accel=30000;
	ch2->Jerk=200000;
	ch2->P=1;
	ch2->I=0;
	ch2->D=0;
	ch2->FFAccel=0;
	ch2->FFVel=0;
	ch2->MaxI=200;
	ch2->MaxErr=200;
	ch2->MaxOutput=200;
	ch2->DeadBandGain=1;
	ch2->DeadBandRange=0;
	ch2->InputChan0=2;
	ch2->InputChan1=3;
	ch2->OutputChan0=6;
	ch2->OutputChan1=5;
	ch2->MasterAxis=-1;
	ch2->LimitSwitchOptions=0x11f;
	ch2->LimitSwitchNegBit=140;
	ch2->LimitSwitchPosBit=141;
	ch2->SoftLimitPos=1e+030;
	ch2->SoftLimitNeg=-1e+030;
	ch2->InputGain0=1;
	ch2->InputGain1=1;
	ch2->InputOffset0=0;
	ch2->InputOffset1=0;
	ch2->OutputGain=-1;
	ch2->OutputOffset=0;
	ch2->SlaveGain=1;
	ch2->BacklashMode=BACKLASH_OFF;
	ch2->BacklashAmount=0;
	ch2->BacklashRate=0;
	ch2->invDistPerCycle=9238.845*2;
	ch2->Lead=0;
	ch2->MaxFollowingError=1000000000;
	ch2->StepperAmplitude=128;

	ch2->iir[0].B0=1;
	ch2->iir[0].B1=0;
	ch2->iir[0].B2=0;
	ch2->iir[0].A1=0;
	ch2->iir[0].A2=0;

	ch2->iir[1].B0=1;
	ch2->iir[1].B1=0;
	ch2->iir[1].B2=0;
	ch2->iir[1].A1=0;
	ch2->iir[1].A2=0;

	ch2->iir[2].B0=1;
	ch2->iir[2].B1=0;
	ch2->iir[2].B2=0;
	ch2->iir[2].A1=0;
	ch2->iir[2].A2=0;
	
	EnableAxisDest(2,0);
	
	ch3->InputMode=NO_INPUT_MODE;
	ch3->OutputMode=STEP_DIR_MODE;
	ch3->Vel=500;
	ch3->Accel=40000;
	ch3->Jerk=4e+006;
	ch3->P=0;
	ch3->I=0.01;
	ch3->D=0;
	ch3->FFAccel=0;
	ch3->FFVel=0;
	ch3->MaxI=200;
	ch3->MaxErr=1e+006;
	ch3->MaxOutput=200;
	ch3->DeadBandGain=1;
	ch3->DeadBandRange=0;
	ch3->InputChan0=0;
	ch3->InputChan1=0;
	ch3->OutputChan0=15;
	ch3->OutputChan1=0;
	ch3->MasterAxis=-1;
	ch3->LimitSwitchOptions=0x100;
	ch3->LimitSwitchNegBit=0;
	ch3->LimitSwitchPosBit=0;
	ch3->SoftLimitPos=1e+030;
	ch3->SoftLimitNeg=-1e+030;
	ch3->InputGain0=1;
	ch3->InputGain1=1;
	ch3->InputOffset0=0;
	ch3->InputOffset1=0;
	ch3->OutputGain=1;
	ch3->OutputOffset=0;
	ch3->SlaveGain=1;
	ch3->BacklashMode=BACKLASH_OFF;
	ch3->BacklashAmount=0;
	ch3->BacklashRate=0;
	ch3->invDistPerCycle=1;
	ch3->Lead=0;
	ch3->MaxFollowingError=1000000000;
	ch3->StepperAmplitude=32;

	ch3->iir[0].B0=1;
	ch3->iir[0].B1=0;
	ch3->iir[0].B2=0;
	ch3->iir[0].A1=0;
	ch3->iir[0].A2=0;

	ch3->iir[1].B0=1;
	ch3->iir[1].B1=0;
	ch3->iir[1].B2=0;
	ch3->iir[1].A1=0;
	ch3->iir[1].A2=0;

	ch3->iir[2].B0=0.000769;
	ch3->iir[2].B1=0.001538;
	ch3->iir[2].B2=0.000769;
	ch3->iir[2].A1=1.92081;
	ch3->iir[2].A2=-0.923885;
	
	EnableAxisDest(3,0);
	
	double Tau = 0.006; // seconds for Low Pass Filter Time Constant
    KLP = exp(-TIMEBASE/Tau);
    printf("Lowpass filter with Tau=%f KLP=%f enabled\n",Tau,KLP);	

	DefineCoordSystem(0,1, 2, 3);

	printf("Configured Axes\n");  // send message to console

	EnableRS232Cmds(RS232_BAUD_4800);	// Enabling RS232-buffer
	DoRS232Cmds=FALSE;

	initializeAxes(); // Initialize axes based on eStop



    int i=0;
    double t0,t1,dt,tmax=0.0;
    unsigned int T0,T1,DT,Tmax=0.0;

    t0=WaitNextTimeSlice();
    T0=*(volatile int *)RTIFRC0;
   
	for (;;) {
        t1=WaitNextTimeSlice();
        T1=*(volatile int *)RTIFRC0;
    
        dt=t1-t0;
        DT=T1-T0;
        t0=t1;
        T0=T1;
        
        if (dt>tmax) tmax=dt;
        if (DT>Tmax) Tmax=DT;
        
        if (++i==10000)
        {
            printf("Max Time Slice = %8.2f us %8.2f us\n",tmax*1e6, ((double)Tmax) * (1.0/CLOCKFREQ) * 1e6);
            t0=WaitNextTimeSlice();
            T0=*(volatile int *)RTIFRC0;
            i=0;
        }

		//WaitNextTimeSlice();
		
		// EStop bit debounce -> True is all ok
		int eStopStatusOk = Debounce(ReadBit(ESTOP),&fcount,&flast,&flastsolid);
		
		// Check if axis not enabled
		if (!ch0->Enable && eStopStatusOk == 1) {
			EnableAxis(0);
			EnableAxis(1);
			EnableAxis(2);
			EnableAxis(3);
			printf("Axes enabled\n");
		} else if (ch0->Enable && eStopStatusOk == 0) {
			DisableAxis(0);
			DisableAxis(1);
			DisableAxis(2);
			DisableAxis(3);
			
			// Stop homing if active
			PauseThread(2);
			printf("EStop! Axes disabled\n");
		} 
	}
}

void initializeAxes() {
	if (ReadBit(ESTOP)) {
		EnableAxis(0);
		EnableAxis(1);
		EnableAxis(2);
		EnableAxis(3);
		printf("Axes enabled\n");
	} else {
		DisableAxis(0);
		DisableAxis(1);
		DisableAxis(2);
		DisableAxis(3);
			
		// Stop homing if active
		PauseThread(2);
		printf("Booting with EStop, axes disabled\n");
	}
}

// Debounce a bit
//
// return 1 one time when first debounced high 
// return 0 one time when first debounced low 
// return -1 otherwise 
#define DBTIME 300

int Debounce(int n, int *cnt, int *last, int *lastsolid)
{
	int v = -1;
	
	if (n == *last)  // same as last time?
	{
		if (*cnt == DBTIME-1)
		{
			if (n != *lastsolid)
			{
				v = *lastsolid = n;  // return debounced value
			}
		}
		if (*cnt < DBTIME)	(*cnt)++;
	}
	else
	{
		*cnt = 0;  // reset count
	}
	*last = n;
	return v;
}
