void init_board()
{
    SetBit(Homing);

	SetBitDirection(SPINDLE_FWD,1);
	SetBitDirection(FAN,1); 
	SetBitDirection(pOutput_Enable,1);  
	SetBitDirection(EN_DRV, 1);
	
	FPGA(STEP_PULSE_LENGTH_ADD)=63;

	char i;
	for (i=0;i<6;i++)
	{
		chan[i].InputMode=ENCODER_MODE;
		//chan[i].OutputMode=CL_STEP_DIR_MODE;
		chan[i].OutputMode=STEP_DIR_MODE;
		chan[i].Vel=120000;
		chan[i].Accel=300000;
		chan[i].Jerk=600000;
		chan[i].P= 0.65;
		chan[i].I=0.01;
		chan[i].D=0;
		chan[i].FFAccel=0;
		chan[i].FFVel=0.01;
		chan[i].MaxI=20000;
		chan[i].MaxErr=1e+009;
		chan[i].MaxOutput=20000;
		chan[i].DeadBandGain=1;
		chan[i].DeadBandRange=0;
		chan[i].InputChan0=i;
		//chan[i].InputChan1=0;
		chan[i].OutputChan0=i+8;
		//chan[i].OutputChan1=0;
		chan[i].MasterAxis=-1;
		chan[i].LimitSwitchOptions=0x0;
		if (rev[i])
			chan[i].InputGain0=1;
		else
			chan[i].InputGain0=-1;
		chan[i].InputGain1=1;
		chan[i].InputOffset0=0;
		chan[i].InputOffset1=0;
		if (rev[i])
			chan[i].OutputGain=-1;
		else
			chan[i].OutputGain=1;
		chan[i].OutputOffset=0;
		chan[i].SlaveGain=1;
		chan[i].BacklashMode=BACKLASH_OFF;
		chan[i].BacklashAmount=0;
		chan[i].BacklashRate=0;
		chan[i].invDistPerCycle=1;
		chan[i].Lead=0;
		chan[i].MaxFollowingError=2000;
		chan[i].StepperAmplitude=250;

		chan[i].iir[0].B0=1;
		chan[i].iir[0].B1=0;
		chan[i].iir[0].B2=0;
		chan[i].iir[0].A1=0;
		chan[i].iir[0].A2=0;

		chan[i].iir[1].B0=1;
		chan[i].iir[1].B1=0;
		chan[i].iir[1].B2=0;
		chan[i].iir[1].A1=0;
		chan[i].iir[1].A2=0;

		chan[i].iir[2].B0=1;
		chan[i].iir[2].B1=0;
		chan[i].iir[2].B2=0;
		chan[i].iir[2].A1=0;
		chan[i].iir[2].A2=0;
		EnableAxis(i);
	}
	DefineCoordSystem6(0, 1, 2, 3, -1, -1); // define axis chan numbers to use as x,y,z,a,b,c (set -1 to disable)
	
	//chan[3].MasterAxis = 0;
	//chan[3].SlaveGain = -1;
    ClearBit(Homing);

}