#include "KMotionDef.h"
#include "Driver\Defines.c

int Home_Single(int axis, int sw int Multiplier)
{
	int index_last;
	int index_this;
	int home_vel = Multiplier * 18000;
	int backup_vel = Multiplier * -2000;
	double savepos;

	Jog(axis, home_vel);		

	while (ReadBit(sw)) // wait for switch to change
	{
		Delay_sec(.001);	// little delay for debounce
		if (CheckDone(axis))
			break;
	}

	Jog(axis,0);		      	// StopMotion
	while(!CheckDone(axis)) ;
	Jog(axis, backup_vel);		
	while (!ReadBit(sw)) // wait for switch to change
	{
		Delay_sec(.001);	// little delay for debounce
		if (CheckDone(axis))
			break;
	}
	savepos = chan[axis].Position;
	Jog(axis,0);		      	// StopMotion
	Move(axis,savepos);
	
	while (!CheckDone(axis)) ;

	Delay_sec(.3);
	Zero(axis);
	Delay_sec(.1);
	
	return 1;
}

int main() 
{
    SetBit(Homing);
	ClearBit(CHECK_SOFT_LIMT);
	Home_Single(Z, pZ_SW, 1);
	Home_Single(X, pX_SW, 1);
	Home_Single(Y, pY_SW, 1);
	Home_Single(A, pA_SW, 1);
	ClearBit(Homing);
	SetBit(CHECK_SOFT_LIMT);
    return 0;
}

