#include "KMotionDef.h"
#include "driver/defines.h"
#include "driver/util.h"

// Switch To Tangental Knife

#define X 0
#define Y 1
#define Z 2
#define A 3
#define B 4

void HomeBAxis();
static int HomeAxis(int axis, int hmSw, int inxSw);

main()
{	
	if (!ReadBit(vbMachineHomed))	// Cancel Op. If machine has not home yet.
		return;

	Move(Z, 0);
	Move(A, 0);
	
	while(!CheckDone(Z))
		;
	while(!CheckDone(A))
		;
		 
	HomeBAxis();
	
	SetBit(pTangentMode);
	Delay_sec(0.5); // Wait for mode to change

}

//----------------------------------------------------------------
void HomeBAxis()
{

	ReadPersist();	

	ClearBit(pTangentMode);
	Delay_sec(0.3); // Wait for mode to change


	fHomeDone[B] = 0;
		
	homeIndexOn[B] = 0; // Force home /w no index
	homeActiveLow[B] = 1;
	HomeAxis(B, vbHomeSwB, vbIndexSwB);
	
	if (fHomeDone[B])
	{		
		// Homing Completed successfully		
		Zero(B);			
		chan[B].Dest = chan[B].Position = HOME_OFFSET_B;
	}
}


//-------
#define StopOnPinChange(axis, pin, state) \
	while (ReadBit(pin) != state)\
	{\
	}\
	Jog(axis, 0);\

//-------
#define WaitDone(axis) \
	while (!CheckDone(axis))\
		;


//----------------------------------------------------------------
static int HomeAxis(int axis, int hmSw, int inxSw)
{
	static int index_this[6];
	static double velSav[6];
	static int moveSpeed;
	static double homePos;

	Move(B, HOME_OFFSET_B);
	WaitDone(axis);

	if (homeActiveLow[axis])
	{
		MoveRel(B, 200);
		WaitDone(axis);
	}

	while(!fHomeDone[axis]) 
	{		
		//if (ReadBit(vbHomeRunning) && !fHomeDone[axis])		
		{
			Jog(axis, homeSpeed[axis] * revHome[axis]);	// Move Toward Switch
			StopOnPinChange(axis, hmSw, homeActiveLow[axis]);

			WaitDone(axis);
			
			Jog(axis, -(homeSpeed[axis] * revHome[axis] / BACKOFF_SPEED_SCALE));	// Backoff
			StopOnPinChange(axis, hmSw, !homeActiveLow[axis]);

			if (homeIndexOn[axis])
			{
				index_this[axis] = ReadBit(inxSw);
				// Continue to Back off until Find Index
				Jog(axis, -(homeSpeed[axis] * revHome[axis] / INDEX_SPEED_SCALE));	
				StopOnPinChange(axis, inxSw, !index_this[axis]);
				
				// Save and move to index position
				hmIndexPos[axis] = GetPos(axis);
				
				// Move To Index Postion + HomeOffset
				velSav[axis] = chan[axis].Vel;
				moveSpeed = abs(homeSpeed[axis] * revHome[axis]);
				chan[axis].Vel = moveSpeed;
				homePos = hmIndexPos[axis] + (homeOffset[axis] * stepsPerIn[axis]);
				//homePos = hmIndexPos[axis];
				Move(axis, homePos);
				WaitDone(axis);			
				chan[axis].Vel = velSav[axis];
			}

			fHomeDone[axis] = 1;
		}
	}
}
