#include "KMotionDef.h"
#include "driver/defines.h"

#define GATH_OFF 0  // define the offset into the Gather buffer where strings are passed

#define X 0
#define Y 1
#define Z 2
#define A 3

// Tool #1 Location
double tool1x =   -30.35;
double tool1y = -9.075;
double tool1z =  -3.72;

double offsetclearz = 3.0; //must be less than abs(tool1z)
double offsetx = 0.0; //y or x has to be zero
double offsety = -3.0; 
double offsetout = 2.0;

double toolY[12];
double toolX[12];
double toolZ[12];

int Current_Tool = 0;
int New_Tool;


void ReleaseTool();
void LockTool();
void MoveInches(int axis, double position);

void DoubleToUserData(int addr, double val);
double UserDataToDouble(int addr);
int ChangeTool(int toolNum);

//---------------------------------
int DoPC(int cmd);
int DoPCFloat(int cmd, float f);
int DoPCInt(int cmd, int i);
int MsgBox(char *s, int Flags);


main()
{
	printf("SP_X:%f\n", UserDataToDouble(pdStepPerInX));

	return;
	
	if (!ReadBit(vbMachineHomed))	// Cancel Op. If machine has not home yet.
	{
		MsgBox("Need to Home Machine First", MB_OK);
		return;
	}

	if (ReadBit(pTangentMode))	// Don't changetool if in Tangentle Knife Mode
		return;
	
	SetBit(vbToolChanging);
	printf("Tool Set to %d\n",persist.UserData[pdNewTool]);  // print the desired speed
	Current_Tool = persist.UserData[pdCurrentTool];
	New_Tool = persist.UserData[pdNewTool];
	
	toolX[0] = tool1x;
	toolX[1] = tool1x;
	toolX[2] = tool1x;
	toolX[3] = tool1x;
	toolX[4] = tool1x;	
	toolX[5] = tool1x;
	toolX[6] = tool1x;
	toolX[7] = tool1x;
	toolX[8] = tool1x;
	toolX[9] = tool1x;
	toolX[10] = tool1x;
	toolX[11] = tool1x;
	toolX[12] = tool1x;
	
	toolY[0] = tool1y - offsety;;
	toolY[1] = tool1y;
	toolY[2] = toolY[1] + offsety;
	toolY[3] = toolY[2] + offsety;
	toolY[4] = toolY[3] + offsety;	
	toolY[5] = toolY[4] + offsety;
	toolY[6] = toolY[5] + offsety;
	toolY[7] = toolY[6] + offsety;
	toolY[8] = toolY[7] + offsety;
	toolY[9] = toolY[8] + offsety;
	toolY[10] = toolY[9] + offsety;
	toolY[11] = toolY[10] + offsety;
	toolY[12] = toolY[11] + offsety;
	
	toolZ[0] = 0;
	toolZ[1] = tool1z;
	toolZ[2] = tool1z;
	toolZ[3] = tool1z;
	toolZ[4] = tool1z;	
	toolZ[5] = tool1z;
	toolZ[6] = tool1z;
	toolZ[7] = tool1z;
	toolZ[8] = tool1z;
	toolZ[9] = tool1z;
	toolZ[10] = tool1z;
	
	
	if (ReadBit(vbMachineHomed) && (Current_Tool != New_Tool) && ReadBit(pEN_DRV) && ReadBit(pOutput_Enable))
	{
		printf("Changing...\n");
		
		SetBit(vbToolChangePause);
		ChangeTool(New_Tool);
		persist.UserData[pdCurrentTool] = Current_Tool;//change current tool to new tool
	}
	Delay_sec(0.5);
	ClearBit(vbToolChangePause);
	ClearBit(vbToolChanging);
}

int ChangeTool(int toolNum) //1-8
{
	MoveInchesWait(Z, 0.0);  // Z Up to home
	if (Current_Tool > 0)
	{
		// Move to last tool position
		MoveInches(X, toolX[Current_Tool] + offsetout);
		MoveInchesWait(Y, toolY[Current_Tool]);

		MoveInchesWait(Z, toolZ[Current_Tool]);  // Z down to rack height
		
		MoveInchesWait(X, toolX[Current_Tool]);
		
		Delay_sec(0.5);//Thread.Sleep(500);  //Wait 0.5 sec
		ReleaseTool();
		Delay_sec(0.5);//Thread.Sleep(500);  //Wait 0.5 sec
		
		MoveInchesWait(Z, toolZ[Current_Tool] + offsetclearz);  // Z Up to clear height
	}


	if (toolNum > 0)
	{
		// Move to new Tool position
		MoveInches(X, toolX[toolNum]);
		MoveInchesWait(Y, toolY[toolNum]);
		
		if (Current_Tool == 0)
		{
			//SetBit(DustHoodBit);
			ReleaseTool();
		}
		
		MoveInchesWait(Z, toolZ[toolNum]);  // Z down to rack height
		Delay_sec(0.5);//Thread.Sleep(500);  //Wait 0.5 sec
		LockTool();
		Delay_sec(0.5);//Thread.Sleep(500);  //Wait 0.5 sec
		
		MoveInchesWait(X, toolX[toolNum] + offsetout);
	}
	else
		LockTool();

	MoveInchesWait(Z, 0.0);  // Z Up to home
	//ClearBit(DustHoodBit);
	
	//Delay_sec(1.0);
	
	Current_Tool = toolNum;
	return 1;
}

void ReleaseTool()
{
	SetBit(pToolRelease);
	
}
void LockTool()
{
	ClearBit(pToolRelease);
}

void MoveInches(int axis, double position)
{
	double steps = 0;

	switch (axis)
	{
		case X:
			steps = position * UserDataToDouble(pdStepPerInX);
			break;
		case Y:
			steps = position * UserDataToDouble(pdStepPerInY);
			break;
		case Z:
			steps = position * UserDataToDouble(pdStepPerInZ);
			break;
		case A:
			steps = position * UserDataToDouble(pdStepPerInA);
			break;
	}
	Move(axis,steps);
}

void MoveInchesWait(int axis, double position)
{
	MoveInches(axis,position);
	while(!CheckDoneXYZABC() || !ReadBit(vbToolChangePause)) {
		if (!ReadBit(pEN_DRV)) //abort the toolchange if active unchecked
		{
			ClearBit(vbToolChanging);
			ThreadDone();
		}
			
		Delay_sec(0.01);
		//WaitNextTimeSlice();
	}
}

//---------------------------------------------------------
//---------------------------------------------------------
 
union DOUBLE
{
  double d;
  int i[2];
}; 

//---------------------------------------------------------
void DoubleToUserData(int addr, double val)
{
	union DOUBLE fVal;
	
	fVal.d = val;
	persist.UserData[addr] = fVal.i[0];
	persist.UserData[addr+1] = fVal.i[1];
	
}

//---------------------------------------------------------
double UserDataToDouble(int addr)
{
	union DOUBLE fVal;
	
	fVal.i[0] = persist.UserData[addr];
	fVal.i[1] = persist.UserData[addr+1];
	
	return  fVal.d;
}

//---------------------------------------------------------
// Trigger a message box on the PC to be displayed
// defines for MS Windows message box styles and Operator
// response IDs are defined in the KMotionDef.h file 
int MsgBox(char *s, int Flags)
{
	char *p=(char *)gather_buffer+GATH_OFF*sizeof(int);
	int i;
	
	do // copy to gather buffer w offset 0
	{
		*p++ = *s++;
	}while (s[-1]);
	
	persist.UserData[PC_COMM_PERSIST+2] = Flags;  // set options
	DoPCInt(PC_COMM_MSG, GATH_OFF);
	return persist.UserData[PC_COMM_PERSIST+3];
}

// put the MDI string (Manual Data Input - GCode) in the 
// gather buffer and tell the App where it is
int MDI(char *s)
{
	char *p=(char *)gather_buffer+GATH_OFF*sizeof(int);
	int i;
	
	do // copy to gather buffer w offset 0
	{
		*p++ = *s++;
	}while (s[-1]);
	
	// issue the command an wait till it is complete
	// (or an error - such as busy)
	return DoPCInt(PC_COMM_MDI,GATH_OFF);
}

// Put a Float as a parameter and pass the command to the App
int DoPCFloat(int cmd, float f)
{
	int result;
	persist.UserData[PC_COMM_PERSIST+1] = *(int*)&f;
	return DoPC(cmd);
}

// Put an integer as a parameter and pass the command to the App
int DoPCInt(int cmd, int i)
{
	int result;
	persist.UserData[PC_COMM_PERSIST+1] = i;
	return DoPC(cmd);
}

// Pass a command to the PC and wait for it to handshake
// that it was received by either clearing the command
// or changing it to a negative error code
int DoPC(int cmd)
{
	int result;
	
	persist.UserData[PC_COMM_PERSIST]=cmd;
	
	do
	{
		WaitNextTimeSlice();	
	}while (result=persist.UserData[PC_COMM_PERSIST]>0);
	
	printf("Result = %d\n",result);

	return result;
}