#ifndef _Util_
#define _Util_

#include "defines.h"
#include "pthread.h"


//---------------------------------------------------------
//---------------------------------------------------------
 
union DOUBLE
{
  double d;
  int i[2];
}; 

//---------------------------------------------------------
void DoubleToUserData(int addr, double val)
{
	union DOUBLE fVal;
	
	fVal.d = val;
	persist.UserData[addr] = fVal.i[0];
	persist.UserData[addr+1] = fVal.i[1];
	
}

//---------------------------------------------------------
double UserDataToDouble(int addr)
{
	union DOUBLE fVal;
	
	fVal.i[0] = persist.UserData[addr];
	fVal.i[1] = persist.UserData[addr+1];
	
	return  fVal.d;
}

//---------------------------------------------------------
double abs(double val)
{
	if (val > 0)
		return val;
	else
		return -val;
}

//---------------------------------------------------------
int SPI_Init()
{
	SetBitDirection(pSS,1);
	SetBitDirection(pMOSI,1);
	SetBitDirection(pMISO,0);
	SetBitDirection(pSCK,1);
}

//---------------------------------------------------------
// Orginal version
//---------------------------------------------------------
int SPI_OUT(int data)
{
	int i;
	int dataIn;
	
	dataIn = 0;
	ClearBit(pSS);
	for (i = 0; i < 8; i++)
	{
		if (data & 0x80)	// look at high bit
			SetBit(pMOSI);
		else
			ClearBit(pMOSI);
		data = data << 1;
		
		dataIn = dataIn << 1;
		if (ReadBit(pMISO))
			dataIn |= 0x01;
		
		SetBit(pSCK);
		ClearBit(pSCK);	
	}
	SetBit(pSS);
	
	return dataIn;
}

//---------------------------------------------------------
void FlashLEDS(void)
{		
	int i;
	
	for (i = 0; i < 6; i++)
	{
		ToggleBit(pLED1);
		Delay_sec(.05);
		ToggleBit(pLED2);
		Delay_sec(.1);			
	}
	for (i = 0; i < 5; i++)
	{
		ClearBit(pLED1);
		ClearBit(pLED2);
		Delay_sec(.05);
		SetBit(pLED1);
		SetBit(pLED2);
		Delay_sec(.05);
	}
}


//----------------------------------------------------------------
// PThread Functions
//----------------------------------------------------------------
struct timer 
{ 
	float start, interval; 
};

//----------------------------------------------------------------
static float clock_time(void)
{
	return (float)Time_sec();
}

//----------------------------------------------------------------
static int timer_expired(struct timer *t)
{ 
	return (float)(Time_sec() - t->start) >= (float)t->interval;
}

//----------------------------------------------------------------
static void timer_set(struct timer *t, float interval)
{ 
	t->interval = interval; 
	t->start = clock_time();
}

//----------------------------------------------------------------
void ToggleBit(int bit)
{
	if (!ReadBit(bit))
		SetBit(bit);
	else
		ClearBit(bit);
}

//---------------------------------------------------------
double GetPos(int axis)
{
#ifdef STEPPER_MODE
	return chan[axis].Dest;
#else	
	return chan[axis].Position;
#endif
}

//---------------------------------------------------------
void Disable(int axis)
{
	DisableAxis(axis);
	ClearBit(pEN_DRV);
	//ClearBit(pLED1);
}


//----------------------------------------------------------------
//----------------------------------------------------------------
//----------------------------------------------------------------
#define MAX_THREAD 10
static struct pt pt[MAX_THREAD];
static struct timer timer[MAX_THREAD];
static int thread_flag[MAX_THREAD];

static int toggle1, toggle2;
static int chCntr;

//----------------------------------------------------------------
#define ThreadSleep(num, sec) \
	timer_set(&timer[num], sec); \
	PT_WAIT_UNTIL(&pt[num], !timer_expired(&timer[num]));

//-------
#define WaitDone2(num, axis) \
	while (!CheckDone(axis))\
	{\
		PT_YIELD(&pt[num]);\
	}

#define WaitDoneDual2(num, axis, axis1) \
	while (!CheckDone(axis) && !CheckDone(axis1))\
	{\
		PT_YIELD(&pt[num]);\
	}

//-------
#define StopOnPinChange2(num, axis, pin, state) \
	while (ReadBit(pin) != state)\
	{\
		PT_YIELD(&pt[num]);\
	}\
	Jog(axis, 0);

//-------
#define StopOnEitherPinChange2(num, axis, pin, state, pin1, state1) \
	while ((ReadBit(pin) != state) && (ReadBit(pin1) != state1))\
	{\
		PT_YIELD(&pt[num]);\
	}\
	Jog(axis, 0);




//----------------------------------------------------------------
void PrintFirmwareVersion()
{
	printf("K2MC FirmwareVersion: %d ", UserDataToDouble(pdFirmwareVersion));

		switch (UserDataToDouble(pdControlType))
	{
		case TYPE_DC_STEP_DIR:
			printf("Type: STEP_DIR\n");
			break;
		case TYPE_AC_SERVO_STEP_DIR:
			printf("Type: AC_SERVO_STEP_DIR\n");
			break;
		case TYPE_AC_SERVO_ANALOG:
			printf("Type: AC_SERVO_ANALOG\n");
			break;
		case TYPE_DC_SERVO:
			printf("Type: DC_SERVO\n");
			break;
		case TYPE_DC_SERVO_REV4:
			printf("Type: DC_SERVO_REV4\n");
			break;
	}

}


//----------------------------------------------------------------
//----------------------------------------------------------------
void ReadPersist()
{
	int i, val;	

	//persist.UserData[pdHomeIndexOn] = 0x0F;
	//persist.UserData[pdHomeActiveLow] = 0x00;

				
	val = persist.UserData[pdRevDir];	
	for (i = 0; i < MAX_AXIS; i++)
	{
		revDir[i] = (val >> i) & 0x01;
		if (revDir[i] > 0)
			chan[i].InputGain0= -1.0;
		else
			chan[i].InputGain0= 1.0;
	}

	val = persist.UserData[pdRevHome];
	for (i = 0; i < MAX_AXIS; i++)
		revHome[i] = ((val >> i) & 0x01)? 1: -1;

	val = persist.UserData[pdHomeActiveLow];
	for (i = 0; i < MAX_AXIS; i++)
		homeActiveLow[i] = (val >> i) & 0x01;

	val = persist.UserData[pdHomeIndexOn];
	for (i = 0; i < MAX_AXIS; i++)
		homeIndexOn[i] = (val >> i) & 0x01;

	val = persist.UserData[pdHomingMode];
	for (i = 0; i < MAX_AXIS; i++)
		homeAxisEn[i] =  (val >> i) & 0x01;

	homeMode = (persist.UserData[pdHomingMode] >> 8) & 0xFF;

	homeSpeed[X] = persist.UserData[pdHomeSpeedX];
	homeSpeed[Y] = persist.UserData[pdHomeSpeedY];
	homeSpeed[Z] = persist.UserData[pdHomeSpeedZ];
	homeSpeed[A] = persist.UserData[pdHomeSpeedA];
	homeSpeed[B] = persist.UserData[pdHomeSpeedB];
	homeSpeed[C] = persist.UserData[pdHomeSpeedC];

	jogSpeed[0] = persist.UserData[pdJogSpeed0];
	jogSpeed[1] = persist.UserData[pdJogSpeed1];
	jogSpeed[2] = persist.UserData[pdJogSpeed2];

	currentSpeed = jogSpeed[0];

	stepsPerIn[X] = UserDataToDouble(pdStepPerInX);
	stepsPerIn[Y] = UserDataToDouble(pdStepPerInY);
	stepsPerIn[Z] = UserDataToDouble(pdStepPerInZ);
	stepsPerIn[A] = UserDataToDouble(pdStepPerInA);
	stepsPerIn[B] = UserDataToDouble(pdStepPerInB);
	stepsPerIn[C] = UserDataToDouble(pdStepPerInC);

	softLimitLo[X] = UserDataToDouble(pdSoftLimitXMin) * stepsPerIn[X];
	softLimitHi[X] = UserDataToDouble(pdSoftLimitXMax) * stepsPerIn[X];

	softLimitLo[Y] = UserDataToDouble(pdSoftLimitYMin) * stepsPerIn[Y];
	softLimitHi[Y] = UserDataToDouble(pdSoftLimitYMax) * stepsPerIn[Y];
	
	softLimitLo[Z] = UserDataToDouble(pdSoftLimitZMin) * stepsPerIn[Z];
	softLimitHi[Z] = UserDataToDouble(pdSoftLimitZMax) * stepsPerIn[Z];
	
	softLimitLo[A] = UserDataToDouble(pdSoftLimitAMin) * stepsPerIn[A];
	softLimitHi[A] = UserDataToDouble(pdSoftLimitAMax) * stepsPerIn[A];

	softLimitHi[B] = UserDataToDouble(pdSoftLimitBMin) * stepsPerIn[B];
	softLimitLo[B] = UserDataToDouble(pdSoftLimitBMax) * stepsPerIn[B];

	softLimitHi[C] = UserDataToDouble(pdSoftLimitCMin) * stepsPerIn[C];
	softLimitLo[C] = UserDataToDouble(pdSoftLimitCMax) * stepsPerIn[C];
	
	homeOffset[X] = UserDataToDouble(pdHomeOffsetX);
	homeOffset[Y] = UserDataToDouble(pdHomeOffsetY);
	homeOffset[Z] = UserDataToDouble(pdHomeOffsetZ);
	homeOffset[A] = UserDataToDouble(pdHomeOffsetA);
	homeOffset[B] = UserDataToDouble(pdHomeOffsetB);
	homeOffset[C] = UserDataToDouble(pdHomeOffsetC);

	switch (persist.UserData[pdSlaveATo])
	{
	case 0:
		chan[A].MasterAxis = 0;
		chan[A].SlaveGain = 0;
		break;
	case 1:
		chan[A].MasterAxis = X;
		chan[A].SlaveGain = 1;
		break;
	case 2:
		chan[A].MasterAxis = Y;
		chan[A].SlaveGain = 1;
		break;
	case 3:
		chan[A].MasterAxis = Z;
		chan[A].SlaveGain = 1;
		break;
	}

}

//---------------------------------------------------------
void WritePersist()
{
	int i, val;
	
	val = 0;
	for (i = 0; i < MAX_AXIS; i++)
		val |= revDir[i] << i;
	persist.UserData[pdRevDir] = val;

	val = 0;
	for (i = 0; i < MAX_AXIS; i++)
		val |= revHome[i] << i;
	persist.UserData[pdRevHome] = val;
	
	val = 0;
	for (i = 0; i < MAX_AXIS; i++)
		val |= homeActiveLow[i] << i;
	persist.UserData[pdHomeActiveLow] = val;
	
}

//----------------------------------------------------------------
// Takes Settings from "K2_Settings.h" and apply them to Persist Data
//----------------------------------------------------------------
void DefaultPersist()
{
	int i, val, res;	

	persist.UserData[pdRevDir] = 
		(REV_DIR_X << 0) | 
		(REV_DIR_Y << 1) | 
		(REV_DIR_Z << 2) | 
		(REV_DIR_A << 3) | 
		(REV_DIR_B << 4) |
		(REV_DIR_C << 5);

	persist.UserData[pdRevHome] = 
		(HOME_DIR_X << 0) | 
		(HOME_DIR_Y << 1) | 
		(HOME_DIR_Z << 2) | 
		(HOME_DIR_A << 3) | 
		(HOME_DIR_B << 4) |
		(HOME_DIR_C << 5);

	persist.UserData[pdHomeActiveLow] = 
		(HOME_ACT_LOW_X << 0) | 
		(HOME_ACT_LOW_Y << 1) | 
		(HOME_ACT_LOW_Z << 2) | 
		(HOME_ACT_LOW_A << 3) | 
		(HOME_ACT_LOW_B << 4) |
		(HOME_ACT_LOW_C << 5);		

	persist.UserData[pdHomeIndexOn] = 
		(HOME_INDEX_X << 0) | 
		(HOME_INDEX_Y << 1) | 
		(HOME_INDEX_Z << 2) | 
		(HOME_INDEX_A << 3) | 
		(HOME_INDEX_B << 4) |
		(HOME_INDEX_C << 5);		
		
	persist.UserData[pdHomingMode] = 
		(HOME_EN_X << 0) | 
		(HOME_EN_Y << 1) | 
		(HOME_EN_Z << 2) | 
		(HOME_EN_A << 3) | 
		(HOME_EN_B << 4) |
		(HOME_EN_C << 5);
	persist.UserData[pdHomingMode] |= (HOME_MODE << 8);
		
		
	persist.UserData[pdHomeSpeedX] = HOME_SPEED_X;
	persist.UserData[pdHomeSpeedY] = HOME_SPEED_Y;
	persist.UserData[pdHomeSpeedZ] = HOME_SPEED_Z;
	persist.UserData[pdHomeSpeedA] = HOME_SPEED_A;
	persist.UserData[pdHomeSpeedB] = HOME_SPEED_B;
	persist.UserData[pdHomeSpeedC] = HOME_SPEED_C;

	persist.UserData[pdJogSpeed0] = JOG_SPEED_0;
	persist.UserData[pdJogSpeed1] = JOG_SPEED_1;
	persist.UserData[pdJogSpeed2] = JOG_SPEED_2;

	DoubleToUserData(pdStepPerInX, STEPS_PER_IN_X);
	DoubleToUserData(pdStepPerInY, STEPS_PER_IN_Y);
	DoubleToUserData(pdStepPerInZ, STEPS_PER_IN_Z);
	DoubleToUserData(pdStepPerInA, STEPS_PER_IN_A);
	DoubleToUserData(pdStepPerInB, STEPS_PER_IN_B);
	DoubleToUserData(pdStepPerInC, STEPS_PER_IN_C);

	DoubleToUserData(pdSoftLimitXMin, LIMIT_X_MIN);
	DoubleToUserData(pdSoftLimitXMax, LIMIT_X_MAX);

	DoubleToUserData(pdSoftLimitYMin, LIMIT_Y_MIN);
	DoubleToUserData(pdSoftLimitYMax, LIMIT_Y_MAX);
	
	DoubleToUserData(pdSoftLimitZMin, LIMIT_Z_MIN);
	DoubleToUserData(pdSoftLimitZMax, LIMIT_Z_MAX);
	
	DoubleToUserData(pdSoftLimitAMin, LIMIT_A_MIN);
	DoubleToUserData(pdSoftLimitAMax, LIMIT_A_MAX);
	
	DoubleToUserData(pdSoftLimitBMin, LIMIT_B_MIN);
	DoubleToUserData(pdSoftLimitBMax, LIMIT_B_MAX);
	
	DoubleToUserData(pdSoftLimitCMin, LIMIT_C_MIN);
	DoubleToUserData(pdSoftLimitCMax, LIMIT_C_MAX);

	/*
	DoubleToUserData(pdHomeOffsetX, HOME_OFFSET_X);
	DoubleToUserData(pdHomeOffsetY, HOME_OFFSET_Y);
	DoubleToUserData(pdHomeOffsetZ, HOME_OFFSET_Z);
	DoubleToUserData(pdHomeOffsetA, HOME_OFFSET_A);
	DoubleToUserData(pdHomeOffsetB, HOME_OFFSET_B);
	DoubleToUserData(pdHomeOffsetC, HOME_OFFSET_C);
	*/
	
	DoubleToUserData(pdHomeOffsetX, 0.0);
	DoubleToUserData(pdHomeOffsetY, 0.0);
	DoubleToUserData(pdHomeOffsetZ, 0.0);
	DoubleToUserData(pdHomeOffsetA, 0.0);
	DoubleToUserData(pdHomeOffsetB, 0.0);
	DoubleToUserData(pdHomeOffsetC, 0.0);

	persist.UserData[pdSlaveATo] = SLAVE_A_TO;
	persist.UserData[pdSlaveBTo] = SLAVE_B_TO;

	persist.UserData[pdBoardDefault] = DEFAULT_KEY;

}


#endif
