#ifndef _initStepDir_
#define _initStepDir_

//---------------------------------------------------------
void InitStepDir(void)
{
	int i;

#ifdef DEBUG
	printf("(Init DC Step/Dir)\n");
#endif

	SetBitDirection(pSpindleFWD, 1);
	SetBitDirection(pSpindleFan, 1); 
	SetBitDirection(pRelay1, 1);
	SetBitDirection(pRelay2, 1);
	SetBitDirection(pOutput_Enable, 1);  
	SetBitDirection(pEN_DRV, 1);	
	
	FPGA(STEP_PULSE_LENGTH_ADD)=63;
		
	chan[X].Vel = MAX_VEL_X;
	chan[Y].Vel = MAX_VEL_Y;
	chan[Z].Vel = MAX_VEL_Z;
	chan[A].Vel = MAX_VEL_A;
	chan[B].Vel = MAX_VEL_B;
	chan[C].Vel = MAX_VEL_C;

	chan[X].Accel = MAX_ACCEL_X;
	chan[Y].Accel = MAX_ACCEL_Y;
	chan[Z].Accel = MAX_ACCEL_Z;
	chan[A].Accel = MAX_ACCEL_A;
	chan[B].Accel = MAX_ACCEL_B;
	chan[C].Accel = MAX_ACCEL_C;

	chan[X].Jerk = MAX_JERK_X;
	chan[Y].Jerk = MAX_JERK_Y;
	chan[Z].Jerk = MAX_JERK_Z;
	chan[A].Jerk = MAX_JERK_A;
	chan[B].Jerk = MAX_JERK_B;
	chan[C].Jerk = MAX_JERK_C;

	chan[X].P = GAIN_P_X;
	chan[Y].P = GAIN_P_Y;
	chan[Z].P = GAIN_P_Z;
	chan[A].P = GAIN_P_A;
	chan[B].P = GAIN_P_B;
	chan[C].P = GAIN_P_C;

	chan[X].I = GAIN_I_X;
	chan[Y].I = GAIN_I_Y;
	chan[Z].I = GAIN_I_Z;
	chan[A].I = GAIN_I_A;
	chan[B].I = GAIN_I_B;
	chan[C].I = GAIN_I_C;

	chan[X].D = GAIN_D_X;
	chan[Y].D = GAIN_D_Y;
	chan[Z].D = GAIN_D_Z;
	chan[A].D = GAIN_D_A;
	chan[B].D = GAIN_D_B;
	chan[C].D = GAIN_D_C;

	chan[X].FFAccel = FF_ACEL_X;
	chan[Y].FFAccel = FF_ACEL_Y;
	chan[Z].FFAccel = FF_ACEL_Z;
	chan[A].FFAccel = FF_ACEL_A;
	chan[B].FFAccel = FF_ACEL_B;
	chan[C].FFAccel = FF_ACEL_C;

	chan[X].FFVel =  FF_VEL_X;
	chan[Y].FFVel =  FF_VEL_Y;
	chan[Z].FFVel =  FF_VEL_Z;
	chan[A].FFVel =  FF_VEL_A;
	chan[B].FFVel =  FF_VEL_B;
	chan[C].FFVel =  FF_VEL_C;

	chan[X].MaxFollowingError = MAX_FOLLOW_ERROR_X;
	chan[Y].MaxFollowingError = MAX_FOLLOW_ERROR_Y;
	chan[Z].MaxFollowingError = MAX_FOLLOW_ERROR_Z;
	chan[A].MaxFollowingError = MAX_FOLLOW_ERROR_A;
	chan[B].MaxFollowingError = MAX_FOLLOW_ERROR_B;
	chan[C].MaxFollowingError = MAX_FOLLOW_ERROR_C;

	for (i = 0; i < MAX_AXIS; i++)
	{
		chan[i].InputMode=ENCODER_MODE;
		chan[i].OutputMode=STEP_DIR_MODE;
		
		chan[i].MaxI=127.000000;
		chan[i].MaxErr=127.000000;
		chan[i].MaxOutput=127.000000;
		chan[i].DeadBandGain=1.000000;
		chan[i].DeadBandRange=0.000000;

		chan[i].InputChan0 = i; //+8;
		chan[i].InputChan1 = 0;

		chan[i].OutputChan0 = i+8;
		chan[i].OutputChan1 = 0;

		//chan[0].OutputChan0=8;	// Pin 8,9 (Ch0)
		//chan[0].OutputChan0=12;	// Pin 36,37 (Ch4)

		//chan[1].OutputChan0=9;	//Pin 10,11 (Ch 1)
		//chan[1].OutputChan0=13;	//Pin 38,39 (Ch 5)

		//chan[2].OutputChan0=10;	//Pin 12,13 (Ch 2)
		//chan[2].OutputChan0=14;	//Pin 40,41 (Ch 6)

		//chan[3].OutputChan0=11; 	//Pin 14,15 (Ch 3)
		//chan[3].OutputChan0=15; 	//Pin 42,43 (Ch 7)


		chan[i].LimitSwitchOptions = 0x00;

		if (revDir[i] > 0)
		{
			chan[i].InputGain0 = -1.0;
			chan[i].OutputGain = 1.0;
		}
		else
		{
			chan[i].InputGain0 = 1.0;
			chan[i].OutputGain = -1.0;
		}
		
		chan[i].InputGain1 = 1.000000;

		chan[i].InputOffset0 = 0.000000;
		chan[i].InputOffset1 = 0.000000;
		chan[i].invDistPerCycle = 1.000000;
		chan[i].Lead = 0.000000;

		chan[i].StepperAmplitude=250.000000;

		chan[i].iir[0].B0=1.000000;
		chan[i].iir[0].B1=0.000000;
		chan[i].iir[0].B2=0.000000;
		chan[i].iir[0].A1=0.000000;
		chan[i].iir[0].A2=0.000000;

		chan[i].iir[1].B0=1.000000;
		chan[i].iir[1].B1=0.000000;
		chan[i].iir[1].B2=0.000000;
		chan[i].iir[1].A1=0.000000;
		chan[i].iir[1].A2=0.000000;

		chan[i].iir[2].B0=1.000000;
		chan[i].iir[2].B1=0.000000;
		chan[i].iir[2].B2=0.000000;
		chan[i].iir[2].A1=0.000000;
		chan[i].iir[2].A2=0.000000;
		
		EnableAxisDest(i, chan[i].Position);
		
		//SetBitDirection(26+i, 1); 		// Set pin for output as PWM
		FPGA(IO_PWMS+pwmCh[i]+1) = 0;	// disable the PWM(0/6) (1,3,5,7,9...)
	}

	switch (persist.UserData[pdSlaveATo])
	{
	case 0:
		chan[A].MasterAxis = 0;
		chan[A].SlaveGain = 0;		
		break;
	case 1:
		chan[A].MasterAxis = X;
		chan[A].SlaveGain = 1;
		break;
	case 2:
		chan[A].MasterAxis = Y;
		chan[A].SlaveGain = 1;
		break;
	case 3:
		chan[A].MasterAxis = Z;
		chan[A].SlaveGain = 1;
		break;
	}

	//DefineCoordSystem6(0, 1, 2, -1, -1, -1); // define axis chan numbers to use as x,y,z,a,b,c (set -1 to disable)
	DefineCoordSystem(0, 1, 2,-1);	

}

//---------------------------------------------------------
void InitACStepDir(void)
{
	int i;

#ifdef DEBUG
	printf("(Init AC Step/Dir)\n");
#endif

	SetBitDirection(pNozzleON, 1);
	SetBitDirection(pTableLOCK, 1); 
	SetBitDirection(pOutput_Enable, 1);  
	SetBitDirection(pEN_DRV, 1);
	SetBitDirection(pDrive_Relay, 1);
	
	// Use Values from "\KFLOP\K2_Settings.h"
	DefaultPersist();	
		
	FPGA(STEP_PULSE_LENGTH_ADD)=63;
	
	chan[X].Vel = MAX_VEL_X;
	chan[Y].Vel = MAX_VEL_Y;
	chan[Z].Vel = MAX_VEL_Z;
	chan[A].Vel = MAX_VEL_A;
	chan[B].Vel = MAX_VEL_B;
	chan[C].Vel = MAX_VEL_C;

	chan[X].Accel = MAX_ACCEL_X;
	chan[Y].Accel = MAX_ACCEL_Y;
	chan[Z].Accel = MAX_ACCEL_Z;
	chan[A].Accel = MAX_ACCEL_A;
	chan[B].Accel = MAX_ACCEL_B;
	chan[C].Accel = MAX_ACCEL_C;

	chan[X].Jerk = MAX_JERK_X;
	chan[Y].Jerk = MAX_JERK_Y;
	chan[Z].Jerk = MAX_JERK_Z;
	chan[A].Jerk = MAX_JERK_A;
	chan[B].Jerk = MAX_JERK_B;
	chan[C].Jerk = MAX_JERK_C;
	
	chan[X].P = GAIN_P_X;
	chan[Y].P = GAIN_P_Y;
	chan[Z].P = GAIN_P_Z;
	chan[A].P = GAIN_P_A;
	chan[B].P = GAIN_P_B;
	chan[C].P = GAIN_P_C;

	chan[X].I = GAIN_I_X;
	chan[Y].I = GAIN_I_Y;
	chan[Z].I = GAIN_I_Z;
	chan[A].I = GAIN_I_A;
	chan[B].I = GAIN_I_B;
	chan[C].I = GAIN_I_C;

	chan[X].D = GAIN_D_X;
	chan[Y].D = GAIN_D_Y;
	chan[Z].D = GAIN_D_Z;
	chan[A].D = GAIN_D_A;
	chan[B].D = GAIN_D_B;
	chan[C].D = GAIN_D_C;

	chan[X].FFAccel = FF_ACEL_X;
	chan[Y].FFAccel = FF_ACEL_Y;
	chan[Z].FFAccel = FF_ACEL_Z;
	chan[A].FFAccel = FF_ACEL_A;
	chan[B].FFAccel = FF_ACEL_B;
	chan[C].FFAccel = FF_ACEL_C;

	chan[X].FFVel =  FF_VEL_X;
	chan[Y].FFVel =  FF_VEL_Y;
	chan[Z].FFVel =  FF_VEL_Z;
	chan[A].FFVel =  FF_VEL_A;
	chan[B].FFVel =  FF_VEL_B;
	chan[C].FFVel =  FF_VEL_C;

	chan[X].MaxFollowingError = MAX_FOLLOW_ERROR_X;
	chan[Y].MaxFollowingError = MAX_FOLLOW_ERROR_Y;
	chan[Z].MaxFollowingError = MAX_FOLLOW_ERROR_Z;
	chan[A].MaxFollowingError = MAX_FOLLOW_ERROR_A;
	chan[B].MaxFollowingError = MAX_FOLLOW_ERROR_B;
	chan[C].MaxFollowingError = MAX_FOLLOW_ERROR_C;
	
	for (i = 0; i < MAX_AXIS; i++)
	{
		chan[i].InputMode=ENCODER_MODE;
		chan[i].OutputMode=STEP_DIR_MODE;
		
		chan[i].MaxI=127.000000;
		chan[i].MaxErr=127.000000;
		chan[i].MaxOutput=127.000000;
		
		chan[i].DeadBandGain=1.000000;
		chan[i].DeadBandRange=0.000000;

		chan[i].InputChan0 = i;
		//chan[i].InputChan1 = 0;

		chan[i].OutputChan0 = i+8;
		//chan[i].OutputChan1 = 0;

		//chan[0].OutputChan0=8;	// Pin 8,9 (Ch0)
		//chan[0].OutputChan0=12;	// Pin 36,37 (Ch4)

		//chan[1].OutputChan0=9;	//Pin 10,11 (Ch 1)
		//chan[1].OutputChan0=13;	//Pin 38,39 (Ch 5)

		//chan[2].OutputChan0=10;	//Pin 12,13 (Ch 2)
		//chan[2].OutputChan0=14;	//Pin 40,41 (Ch 6)

		//chan[3].OutputChan0=11; 	//Pin 14,15 (Ch 3)
		//chan[3].OutputChan0=15; 	//Pin 42,43 (Ch 7)


		chan[i].LimitSwitchOptions = 0x00;

		if (revDir[i] > 0)
		{
			chan[i].InputGain0 = -1.0;
			chan[i].OutputGain = 1.0;
		}
		else
		{
			chan[i].InputGain0 = 1.0;
			chan[i].OutputGain = -1.0;
		}
	
		chan[i].InputGain1 = 1.000000;

		chan[i].InputOffset0 = 0.000000;
		chan[i].InputOffset1 = 0.000000;
		chan[i].invDistPerCycle = 1.000000;
		chan[i].Lead = 0.000000;

		chan[i].MaxFollowingError=1000.000000;
		chan[i].StepperAmplitude=250.000000;

		chan[i].iir[0].B0=1.000000;
		chan[i].iir[0].B1=0.000000;
		chan[i].iir[0].B2=0.000000;
		chan[i].iir[0].A1=0.000000;
		chan[i].iir[0].A2=0.000000;

		chan[i].iir[1].B0=1.000000;
		chan[i].iir[1].B1=0.000000;
		chan[i].iir[1].B2=0.000000;
		chan[i].iir[1].A1=0.000000;
		chan[i].iir[1].A2=0.000000;

		chan[i].iir[2].B0=1.000000;
		chan[i].iir[2].B1=0.000000;
		chan[i].iir[2].B2=0.000000;
		chan[i].iir[2].A1=0.000000;
		chan[i].iir[2].A2=0.000000;
		
		EnableAxisDest(i, chan[i].Position);
		
		//SetBitDirection(26+i, 1); 		// Set pin for output as PWM
		FPGA(IO_PWMS+pwmCh[i]+1) = 0;	// disable the PWM(0/6) (1,3,5,7,9...)
	}

	switch (persist.UserData[pdSlaveATo])
	{
	case 0:
		chan[A].MasterAxis = 0;
		chan[A].SlaveGain = 0;		
		break;
	case 1:
		chan[A].MasterAxis = X;
		chan[A].SlaveGain = 1;
		break;
	case 2:
		chan[A].MasterAxis = Y;
		chan[A].SlaveGain = 1;
		break;
	case 3:
		chan[A].MasterAxis = Z;
		chan[A].SlaveGain = 1;
		break;
	}

	// 3 Axis System 
	//DefineCoordSystem6(0, 1, 2, -1, -1, -1); // define axis chan numbers to use as x,y,z,a,b,c (set -1 to disable)
	//DefineCoordSystem(0, 1, 2,-1);	
	
	DEFINE_COORD;

}



#endif