//----------------------------------------------------------------
// KFLOP Homing routine
// K2CNC - Copyright 2013
// Version: 2.0.4
//
// - Homing.c  -> Thread 5
//----------------------------------------------------------------
// Last Modified: 10-02-2013
//
//
//----------------------------------------------------------------

#include "KMotionDef.h"
#include "defines.h"
#include "pthread.h"
#include "util.h"

//---------------------------------------------------------
//---------------------------------------------------------
void ReadPersist();
void WritePersist();

int ChkOnSwitch(int Axis);
int ChkOffSwitch(int Axis);

static int myHomeThread(int axis, int hmSw, int inxSw);
static int myHomeThreadDual(int axis0, int hmSw0, int inxSw0, int axis1, int hmSw1, int inxSw1);

//---------------------------------------------------------
//---------------------------------------------------------
main()
{
	int i;
		
	SetBit(vbThread5Started);
	
	if (ReadBit(vbHomeRunning))	
	{
		ClearBit(vbAbortHome);

		ReadPersist();	

		// Skip homing for these axis if not enabled
		fHomeDone[X] = !homeAxisEn[X];
		fHomeDone[Y] = !homeAxisEn[Y];
		fHomeDone[Z] = !homeAxisEn[Z];
		fHomeDone[A] = !homeAxisEn[A];

		printf("HomeRunning:%d fHomeDone[z]%d\n", ReadBit(vbHomeRunning), fHomeDone[Z]);

		myHomeThread(Z, vbHomeSwZ, vbIndexSwZ);
		//myHomeThreadDual(Y, vbHomeSwY, vbIndexSwY, A, vbHomeSwA, vbIndexSwA);
		myHomeThread(Y, vbHomeSwY, vbIndexSwY);
		myHomeThread(X, vbHomeSwX, vbIndexSwX);

	
		if (fHomeDone[X] && fHomeDone[Y] && fHomeDone[Z] && fHomeDone[A])
		{		
			// Homing Completed successfully		
			Zero(X);
			Zero(Y);
			Zero(Z);
			Zero(A);
			Zero(B);
			Zero(C);

			SetBit(vbMachineHomed);
			SetBit(vbSoftlimitEn);
		}		
	}

	ClearBit(vbHomeRunning);
	ClearBit(vbHomeStarted);

	ClearBit(vbThread5Started);
}
//---------------------------------------------------------
//---------------------------------------------------------


//-------
#define StopOnPinChange(axis, pin, state) \
	while (ReadBit(pin) != state)\
	{\
		if (!ReadBit(vbHomeRunning))\
			break;\
	}\
	Jog(axis, 0);\
	if (!ReadBit(vbHomeRunning))\
		break;

//-------
#define StopOnEitherPinChange(axis, pin, state, pin1, state1) \
	while ((ReadBit(pin) != state) && (ReadBit(pin1) != state1))\
	{\
		if (!ReadBit(vbHomeRunning))\
			break;\
	}\
	Jog(axis, 0);\
	if (!ReadBit(vbHomeRunning))\
		break;

//-------
#define WaitDone(axis) \
	while (!CheckDone(axis))\
		;

//----------------------------------------------------------------
int ChkOnSwitch(int Axis)
{
	return !(ReadBit(vbHomeSwX + Axis) == homeActiveLow[Axis]);
}

//----------------------------------------------------------------
int ChkOffSwitch(int Axis)
{
	return (ReadBit(vbHomeSwX + Axis) == homeActiveLow[Axis]);
}


//----------------------------------------------------------------
static int myHomeThread(int axis, int hmSw, int inxSw)
{
	static int index_this[6];
	static double velSav[6];
	static int moveSpeed;
	static double homePos;

	if (!ReadBit(vbHomeRunning))
		return;
		
	while(!fHomeDone[axis]) 
	{		
		if (ReadBit(vbHomeRunning) && !fHomeDone[axis])
		{
			Jog(axis, homeSpeed[axis] * revHome[axis]);	// Move Toward Switch
			StopOnPinChange(axis, hmSw, homeActiveLow[axis]);
			
			WaitDone(axis);
			
			Jog(axis, -(homeSpeed[axis] * revHome[axis] / BACKOFF_SPEED_SCALE));	// Backoff
			StopOnPinChange(axis, hmSw, !homeActiveLow[axis]);

			if (homeIndexOn[axis])
			{
				index_this[axis] = ReadBit(inxSw);
				// Continue to Back off until Find Index
				Jog(axis, -(homeSpeed[axis] * revHome[axis] / INDEX_SPEED_SCALE));	
				StopOnPinChange(axis, inxSw, !index_this[axis]);
				
				// Save and move to index position
				hmIndexPos[axis] = GetPos(axis);
				
				// Move To Index Postion + HomeOffset
				velSav[axis] = chan[axis].Vel;
				moveSpeed = abs(homeSpeed[axis] * revHome[axis]);
				chan[axis].Vel = moveSpeed;
				homePos = hmIndexPos[axis] + (homeOffset[axis] * stepsPerIn[axis]);
				//homePos = hmIndexPos[axis];
				Move(axis, homePos);
				WaitDone(axis);			
				chan[axis].Vel = velSav[axis];
			}

			WaitDone(axis);
			Delay_sec(0.1);

			fHomeDone[axis] = 1;
		}
	}
}

//----------------------------------------------------------------
static int myHomeThreadDual(int axis0, int hmSw0, int inxSw0, int axis1, int hmSw1, int inxSw1)
{
	static int index_this0, index_this1;
	static int moveSpeed;
	static double velSav0, velSav1;
	static int hitSw0;
	static int indexHit0, indexHit1;
	static double homePos0, homePos1;

	moveSpeed = abs(homeSpeed[axis1] * revHome[axis1]);
//Debug
//#define HM_DEBUG

#ifdef HM_DEBUG
	printf("HomeMode:%d\n", homeMode);
#endif

	if (!ReadBit(vbHomeRunning))
		return;

	while(!fHomeDone[axis0] || !fHomeDone[axis1]) 
	{		
		if (ReadBit(vbHomeRunning) && !fHomeDone[axis0])
		{			
			Jog(axis0, homeSpeed[axis0] * revHome[axis0]);	// Move Toward Switches
			StopOnEitherPinChange(axis0, hmSw0, homeActiveLow[axis0], hmSw1, homeActiveLow[axis1]);

			if( ReadBit(hmSw0) == homeActiveLow[axis0])
				hitSw0 = 1;
			else
				hitSw0 = 0;

#ifdef HM_DEBUG
	printf("HitSw0:%d\n", hitSw0);
#endif
			Jog(axis0, -(homeSpeed[axis0] * revHome[axis0] / BACKOFF_SPEED_SCALE));	// Backoff
			if (hitSw0)
			{
				StopOnPinChange( axis0, hmSw0, !homeActiveLow[axis0]);
			}
			else
			{
				StopOnPinChange( axis1, hmSw1, !homeActiveLow[axis1]);
			}

			if (homeIndexOn[axis0])
			{
				index_this0 = ReadBit(inxSw0);
				index_this1 = ReadBit(inxSw1);
				// Continue to Back off until Find Index
				Jog(axis0, -(homeSpeed[axis0] * revHome[axis0] / INDEX_SPEED_SCALE));

				indexHit0 = indexHit1 = 0;
				while ((indexHit0 == 0) || (indexHit1 == 0))
				{
					if (!indexHit0 && index_this0 != ReadBit(inxSw0))
					{
						hmIndexPos[axis0] = GetPos(axis0);	
						indexHit0 = 1;
					}	
					if (!indexHit1 && index_this1 != ReadBit(inxSw1))
					{
						hmIndexPos[axis1] = GetPos(axis1);	
						indexHit1 = 1;
					}	

				}
				Jog(axis0, 0);	

				// Move To Index Postion + HomeOffset
				velSav0 = chan[axis0].Vel;
				velSav1 = chan[axis1].Vel;
				chan[axis0].Vel = moveSpeed;
				chan[axis1].Vel = moveSpeed;			
				homePos0 = hmIndexPos[axis0] + (homeOffset[axis0] * stepsPerIn[axis0]);
				Move(axis0, homePos0);
				WaitDone(axis0);
				homePos1 = hmIndexPos[axis1] + (homeOffset[axis1] * stepsPerIn[axis1]);
				Move(axis1, homePos1);
				WaitDone(axis1);
				//WaitDoneDual(this, axis0, axis1);			
				chan[axis0].Vel = velSav0;
				chan[axis1].Vel = velSav1;

			}

			fHomeDone[axis0] = 1;
			fHomeDone[axis1] = 1;
		}
	}
}
