/*click_board.h
*
*Driver file for Microchip MCP23S17 16pin SPI port expander IC
*PORT A all 
*
*
*/

#include "KMotionDef.h"
#include "Defines.h"
 
#define pMOSI	36
#define pMISO	37
#define pSCK	38
#define pSS		39

#define pRST	40

#define LED	  	46

#define Device_R		0x41
#define Device_W		0x40
#define ICON			0x0A
#define JUNK			0x00

/***************************************************************************************
********************************* IOCON.BANK = 1 ***************************************
***************************************************************************************/

/**************************
*PORT A
***************************/

#define IODIRA			0x00	// I/O DIRECTION REGISTER(0=output 1=input)
#define IPOLA			0x01	// INPUT POLARITY REGISTER (0=normal 1=inverted)
#define GPINTENA		0x02	// INTERRUPT-ON-CHANGE CONTROL REGISTER (0=disable 1=enable)
#define DEFVALA			0x03	// DEFAULT COMPARE REGISTER FOR INTERRUPT-ON-CHANGE
#define INTCONA			0x04	// INTERRUPT CONTROL REGISTER (0=against previous pin 1=DEFVAL)
#define IOCONA			0x05	// CONFIGURATION REGISTER
#define GPPUA			0x06	// PULL-UP RESISTOR CONFIGURATION REGISTER (0=disable 1=enable)
#define INTFA			0x07	// INTERRUPT FLAG REGISTER (0=not pending 1=interrupt)
#define INTCAPA			0x08	// INTERRUPT CAPTURE REGISTER (0=logic-low 1=logic-high)
#define GPIOA			0x09	// PORT REGISTER (0=logic-low 1=logic-high)
#define OLATA			0x0A	// OUTPUT LATCH REGISTER (0=logic-low 1=logic-high)

/****************************
*PORT B
*****************************/

#define IODIRB 			0x10
#define IPOLB			0x11
#define GPINTENB		0x12
#define DEFVALB			0x13
#define INTCONB			0x14
#define ICONB			0x15
#define GPPUB			0x16
#define INTFB			0x17
#define INTCAPB			0x16
#define GPIOB			0x19
#define OLATB			0x1A



/*
***************************************************************************************
********************************* IOCON.BANK = 0 ***************************************
***************************************************************************************

**************************
*PORT A
***************************

#define IODIRA			0x00
#define IPOLA			0x02
#define GPINTENA		0x04
#define DEFVALA			0x06
#define INTCONA			0x08
#define IOCONA			0x0A
#define GPPUA			0x0C
#define INTFA			0x0E
#define INTCAPA			0x10
#define GPIOA			0x12
#define OLATA			0x14

****************************
*PORT B
*****************************

#define IODIRB 			0x01
#define IPOLB			0x03
#define GPINTENB		0x05
#define DEFVALB			0x07
#define INTCONB			0x09
#define ICONB			0x0B
#define GPPUB			0x0D
#define INTFB			0x0F
#define INTCAPB			0x11
#define GPIOB			0x13
#define OLATB			0x15

*/

void PortA_Write(int value);
int PortB_Read();
int SPI_write(int data);
void setup();
void config_ICON();
void config_PORTA();
void config_PORTB();


//-------------------------------------------------
int main()
{
	int result;


	setup();
	
	
	//write to PORT A

	while (1)
	{
		//PortA_Write(result);
		PortA_Write(0x03);
		result = PortB_Read();		
		printf("1 data:0x%02x\n", result);

		Delay_sec(.2);		
		PortA_Write(0);				
		result = PortB_Read();		
		printf("data:0x%02x\n", result);
		
		Delay_sec(.2);
	}				
}

void PortA_Write(int value)
{
	ClearBit(pSS);
	SPI_write(Device_W);			//Opcode write mode		[0x40]
	SPI_write(GPIOA);				//Select GPIO A			[0x09]
	SPI_write(value);
	SetBit(pSS);
}

int PortB_Read()
{
	int result;
	
	result = 0x12;
	
	ClearBit(pSS);
	SPI_write(Device_R);		 	//Opcode read mode		[0x41]
	SPI_write(GPIOB);		 		//Select port B			[0x19]
	result = SPI_write(JUNK);		//Send junk to pass		[0x00]
	SetBit(pSS);

	
	return result;
}

int SPI_write(int data)
{
	int i;
	unsigned char dataIn;
	
	dataIn = 0;
	
	for (i = 0; i <8; i++)
	{
		if (data & 0x80)		// look at high bit
			SetBit(pMOSI);
		else
			ClearBit(pMOSI);
			
		data = data << 1;		
		dataIn = dataIn << 1;	
			
		if (ReadBit(pMISO))
			dataIn |= 0x01;
		
		SetBit(pSCK);
		ClearBit(pSCK);	
	}

	return dataIn;
}

void setup()
{
	SetBitDirection(pSS, 1);
	SetBitDirection(pMISO, 0);
	SetBitDirection(pMOSI, 1);
	SetBitDirection(pSCK, 1);
	
	ClearBit(pRST);
	SetBit(pRST);
	
	config_ICON();
	config_PORTA();
	config_PORTB();
}

//config ICON
void config_ICON()
{
	SetBit(pSS);
	ClearBit(pSS);
	SPI_write(Device_W);			// Opcode write mode 	[0x40]
	SPI_write(ICON);				// Default ICON			[0x0A]
	SPI_write(0xA0);		 		// ob10100000 			[0xA0]
	SetBit(pSS);
}


//setup Port A all outputs
void config_PORTA()
{
	ClearBit(pSS);
	SPI_write(Device_W);			//Opcode write mode		[0x40]
	SPI_write(IODIRA);				//Select port A			[0x00]
	SPI_write(0x00);				//Set to all output		[0x00]
	SetBit(pSS);
}


//setup port B all inputs
void config_PORTB()
{
	ClearBit(pSS);
	SPI_write(Device_W);			//Opcode write mode		[0x40]
	SPI_write(IODIRB);				//Select port B			[0x10]
	SPI_write(0xFF);				//Set to all input		[0xFF]
	SetBit(pSS);
}