#ifndef _events_
#define _events_

static int cbDC_PWM();
static int cbChkEnableSw();
static int cbChkDriveFault();
static int cbChkEvents();

static int cbScanSPI();
static int cbScanSPI_DC_SERVO();
static int cbScanSPI_AC_SERVO_STEP_DIR();

//---------------------------------------------------------
//---------------------------------------------------------
//---------------------------------------------------------
// This Function Gets Loop Continuously once Main thread 
// itializes
//---------------------------------------------------------
// This callback (inerrupt routine) is run every 90uS, keep it very short!!
void CallBack(void)
{  
	static int mode = 0;

	if (ReadBit(vbInitialized))	// Loop as long as this bit is set
	{
		switch (persist.UserData[pdControlType])
		{
		case TYPE_DC_SERVO:
		case TYPE_DC_SERVO_REV4:
			cbDC_PWM();
			break;
		case TYPE_DC_STEP_DIR:
			break;
		case TYPE_AC_SERVO_ANALOG:
			break;
		case TYPE_AC_SERVO_STEP_DIR:
			break;
		default:
			break;
		}

		// Run the follow case once per callback (Time sliced)
		switch(mode)
		{
		case 0:
			switch (persist.UserData[pdControlType])
			{
			case TYPE_DC_SERVO:
			case TYPE_DC_SERVO_REV4:
				cbScanSPI_DC_SERVO();
				break;
			case TYPE_DC_STEP_DIR:
				break;
			case TYPE_AC_SERVO_ANALOG:
				break;
			case TYPE_AC_SERVO_STEP_DIR:
				//cbScanSPI_AC_SERVO_STEP_DIR(1);
				break;
			default:
				break;
			}

			mode++;
			break;
		case 1:		
			cbChkEnableSw();
			mode++;
			break;
		case 2:
			cbChkDriveFault();
			mode++;
			break;
		default:
			cbChkEvents();
			mode = 0;
			break;
		}		 
	}
}

//----------------------------------------------------------------
//----------------------------------------------------------------
static int cbDC_PWM()
{
	if (chan[0].Enable)
		if (revDir[0] > 0)
			FPGA(IO_PWMS+0) = (chan[0].Output + 128);  // +128 converts to anti-phase
		else
			FPGA(IO_PWMS+0) = 512 - (chan[0].Output + 128);  // +128 converts to anti-phase
	else
		FPGA(IO_PWMS+0) = 128;  // whenever not enabled put 50% duty cycle

	if (chan[1].Enable)
		if (revDir[1] > 0)
			FPGA(IO_PWMS+2) = (chan[1].Output + 128);  // +128 converts to anti-phase
		else
			FPGA(IO_PWMS+2) = 512 - (chan[1].Output + 128);  // +128 converts to anti-phase
	else
		FPGA(IO_PWMS+2) = 128;  // whenever not enabled put 50% duty cycle

	if (chan[2].Enable)
		if (revDir[2] > 0)
			FPGA(IO_PWMS+4) = (chan[2].Output + 128);  // +128 converts to anti-phase
		else
			FPGA(IO_PWMS+4) = 512 - (chan[2].Output + 128);  // +128 converts to anti-phase
	else
		FPGA(IO_PWMS+4) = 128;  // whenever not enabled put 50% duty cycle

	if (chan[3].Enable)
		if (revDir[3] > 0)
			FPGA(IO_PWMS+6) = (chan[3].Output + 128);  // +128 converts to anti-phase
		else
			FPGA(IO_PWMS+6) = 512 - (chan[3].Output + 128);  // +128 converts to anti-phase
	else
		FPGA(IO_PWMS+6) = 128;  // whenever not enabled put 50% duty cycle

#if MAX_ACTIVE_AXIS >= 5
	if (chan[4].Enable)
		if (revDir[4] > 0)
			FPGA(IO_PWMS+8) = (chan[4].Output + 128);  // +128 converts to anti-phase
		else
			FPGA(IO_PWMS+8) = 512 - (chan[4].Output + 128);  // +128 converts to anti-phase
	else
		FPGA(IO_PWMS+8) = 128;  // whenever not enabled put 50% duty cycle
#endif

#if MAX_ACTIVE_AXIS >= 6		
	if (chan[5].Enable)
		if (revDir[5] > 0)
			FPGA(IO_PWMS+10) = (chan[5].Output + 128);  // +128 converts to anti-phase
		else
			FPGA(IO_PWMS+10) = 512 - (chan[5].Output + 128);  // +128 converts to anti-phase
	else
		FPGA(IO_PWMS+10) = 128;  // whenever not enabled put 50% duty cycle

#endif
}

//----------------------------------------------------------------
//-- Check for Enable Push Button
static int cbChkEnableSw()
{
	static double startTime = 0;

	if (ReadBit(pEN_SW))
	{
		// Start Timer when button 1st press
		if (startTime == 0)		
			startTime = Time_sec();
		
		// If hold on to button for more than 0.5 Sec than enable Drives
		if ((Time_sec() - startTime) > 0.5 )
		{
			EnableAxis(0);
			EnableAxis(1);
			EnableAxis(2);
			EnableAxis(3);
			EnableAxis(4);
			
			SetBit(vbDriveEnable);
			//ClearBit(pEN_DRV);
			SetBit(pEN_DRV);
			SetBit(pSpindleFan);
			SetBit(pOutput_Enable);
			SetBit(pDrive_Relay);
			//SetBit(pRelay4);	// Active LED
		}
	}
	else
		startTime = 0;
}

//----------------------------------------------------------------
//-- Check for drive fault and E-Stop active
static int cbChkDriveFault()
{
	if (!ReadBit(vbHomeRunning) && (!ReadBit(vbStepResponse)))
	{		
		if ((!chan[X].Enable) |
			(!chan[Y].Enable) |
			(!chan[Z].Enable) |
			(!chan[A].Enable) |
			(!chan[B].Enable))		    
		{
			if (ReadBit(pEN_DRV))
			{
				if (!chan[X].Enable)
					SetBit(vbFaultX);
				if (!chan[Y].Enable)
					SetBit(vbFaultY);				
				if (!chan[Z].Enable)
					SetBit(vbFaultZ);
				if (!chan[A].Enable)
					SetBit(vbFaultA);
				if (!chan[B].Enable)
					SetBit(vbFaultB);
			}			
			
			ClearBit(pEN_DRV);
			ClearBit(pSpindleFan);
		}	
	}

	if (!ReadBit(pESTOP_SW)) 
	{	
		DisableAxis(0);
		DisableAxis(1);
		DisableAxis(2);
		DisableAxis(3);
		DisableAxis(4);

		ClearBit(pEN_DRV);
		ClearBit(pSpindleFan);
		ClearBit(pOutput_Enable);
		ClearBit(pRelay1);
		ClearBit(pRelay2);
		ClearBit(pRelay3);
		ClearBit(pRelay4);

		ClearBit(vbFaultX);
		ClearBit(vbFaultY);				
		ClearBit(vbFaultZ);
		ClearBit(vbFaultA);			
		ClearBit(vbFaultB);			
	} 
}
	
//----------------------------------------------------------------
//-- Get Home Switches and Index Pulse via SPI port
static int cbScanSPI_DC_SERVO()
{
	spiData = SPI_OUT(0);

	//PT_YIELD(&pt[this]);

	if ((spiData & 0xf0) == 0x00)
	{
		if (spiData & 0x01)
			SetBit(vbHomeSwX); 
		else
			ClearBit(vbHomeSwX);
		if (spiData & 0x02)
			SetBit(vbIndexSwX); 
		else
			ClearBit(vbIndexSwX);
	}
	
	if (((spiData & 0xf0) >> 4) == 1)
	{
		if (spiData & 0x01)
			SetBit(vbHomeSwY); 
		else
			ClearBit(vbHomeSwY);
		if (spiData & 0x02)
			SetBit(vbIndexSwY); 
		else
			ClearBit(vbIndexSwY);
	}
	
	if ((spiData & 0xf0) == 0x20)
	{
		if (spiData & 0x01)
			SetBit(vbHomeSwZ);
		else
			ClearBit(vbHomeSwZ);
		if (spiData & 0x02)
			SetBit(vbIndexSwZ); 
		else
			ClearBit(vbIndexSwZ);
	}
	
	if ((spiData & 0xf0) == 0x30)
	{
		if (spiData & 0x01)
			SetBit(vbHomeSwA); 
		else
			ClearBit(vbHomeSwA);
		if (spiData & 0x02)
			SetBit(vbIndexSwA); 
		else
			ClearBit(vbIndexSwA);
	}
}

//----------------------------------------------------------------
static int cbScanSPI_AC_SERVO_STEP_DIR()
{
	spiData = SPI_OUT(spiOutput);

	if ((spiData & 0x80) == 0x00)	// Index Pulse
	{
		if (spiData & 0x01)
			SetBit(vbIndexSwX); 
		else
			ClearBit(vbIndexSwX);
		
		if (spiData & 0x02)
			SetBit(vbIndexSwY); 
		else
			ClearBit(vbIndexSwY);
		if (spiData & 0x04)
			SetBit(vbIndexSwZ); 
		else
			ClearBit(vbIndexSwZ);
		if (spiData & 0x08)
			SetBit(vbIndexSwA); 
		else
			ClearBit(vbIndexSwA);
#ifdef MAX_AXIS >= 5
		if (spiData & 0x10)
			SetBit(vbIndexSwB); 
		else
			ClearBit(vbIndexSwB);
#endif			
#ifdef MAX_AXIS >= 6
		if (spiData & 0x20)
			SetBit(vbIndexSwC); 
		else
			ClearBit(vbIndexSwC);
#endif			
	}

	if ((spiData & 0x80) == 0x80)	// Fault
	{
		if (spiData & 0x01)
			SetBit(vbFaultX); 
		else
			ClearBit(vbFaultX);
		if (spiData & 0x02)
			SetBit(vbFaultY); 
		else
			ClearBit(vbFaultY);
		if (spiData & 0x04)
			SetBit(vbFaultZ); 
		else
			ClearBit(vbFaultZ);
		if (spiData & 0x08)
			SetBit(vbFaultA); 
		else
			ClearBit(vbFaultA);
#ifdef MAX_AXIS >= 5
		if (spiData & 0x10)
			SetBit(vbFaultB); 
		else
			ClearBit(vbFaultB);
#endif			
#ifdef MAX_AXIS >= 6
		if (spiData & 0x20)
			SetBit(vbFaultC); 
		else
			ClearBit(vbFaultC);
#endif
	}
}

//----------------------------------------------------------------
static int cbChkEvents()
{
	// Check if RevDir bits has changed
	if (revDirSav != persist.UserData[pdRevDir] )
	{
		revDirSav = persist.UserData[pdRevDir];
		for (i = 0; i < MAX_AXIS; i++)
		{
			revDir[i] = (revDirSav >> i) & 0x01;
			if (revDir[i] > 0)
				chan[i].InputGain0= -1.0;
			else
				chan[i].InputGain0= 1.0;
		}			
	}
			
	if (ReadBit(vbHomeRunning))
	{			

		if (!ReadBit(vbHomeStarted))
		{
			SetBit(vbHomeStarted);
			ClearBit(vbAbortHome);
			ClearBit(vbMachineHomed);
			ClearBit(vbSoftlimitEn);

			StartThread(HOMING_THREAD);
		}
	}
	
	/*
	if (ReadBit(vbToolChanging))
	{			
		if (!ReadBit(vbToolChangeStarted))
		{
			SetBit(vbToolChangeStarted);
			ClearBit(vbAbortToolChange);
			StartThread(TOOLCHANGE_THREAD);
		}
	}	
	*/
	
	if (ReadBit(pRUN_SW))
	{

	}
}


#endif