//----------------------------------------------------------------
// KFLOP Bit Joging and Softlimit routine
// K2CNC - Copyright 2013
// Version: 2.0.4
//
// - bitJog_sLimit.c  -> Thread 1
//----------------------------------------------------------------
// Last Modified: 10-02-2013
//
//----------------------------------------------------------------

#include "KMotionDef.h"
#include "defines.h"
#include "pthread.h"
#include "util.h"
#include "..\k2_settings.h"

//---------------------------------------------------------
//---------------------------------------------------------
void ReadPersist();
void WritePersist();

void ChkBitJog(int axis, int bitAddress, int atlimitBit);

int SPI_IO_Init();
int SPI_IO_OUT(int data);

//---------------------------------------------------------
//---------------------------------------------------------
main()
{		
	int i;
	int fUpdatePersist = 0;
	int masterOfADrive;
	double slavePos[2];
	double masterPos[2];

	int spindleOnProx = 0;
	int spindleOnProxLast = 0;
	int spindleOnCntr = 0;
	int spindleOffCntr = 0;
	
	int spinleIsOff;
	
	int expandIn;
	int expandOut;
	
	isMoving[0] = 0;
	ReadPersist();
	
	if (EXPAND_IO_EN)
		SPI_IO_Init();

	while(1)
	{
		WaitNextTimeSlice();
		
		if (ReadBit(vbUpdateFromPersist))
		{
			ReadPersist();			
			Delay_sec(.5);
			ClearBit(vbUpdateFromPersist);
		}
		
		// Toolrelease Button
		/*
		if(!ReadBit(pSpindleFWD))
		{
			//printf("Button:%d\n", pToolReleaseButton);
			if (!ReadBit(pToolReleaseButton)) // Active Low
			{
				printf("Tool Release\n");
				SetBit(pToolReleaseOutput);
				while(!ReadBit(pToolReleaseButton))
					;
				ClearBit(pToolReleaseOutput);					
			}
		}
		*/
		
		// Check if Spindle is Spinning
/*		
		spindleOnProx = ReadBit(pSpindleStopSw);
		if(spindleOnProxLast == spindleOnProx)
		{
			if (spindleOffCntr < 5000)
				spindleOffCntr++;
		}
		else
		{
			spindleOnProxLast = spindleOnProx;
			spindleOffCntr = 0;
	
			if (spindleOnCntr < 5000)
				spindleOnCntr++;
		}

		if (spindleOnCntr > 10)
		{
			SetBit(vbSpindleRunning);			
		}
	
		if (spindleOffCntr > 200)
		{
			spindleOnCntr = 0;			
			ClearBit(vbSpindleRunning);
		}
*/
		
		// SPI Expand I/O
		if (EXPAND_IO_EN)
		{			
			expandOut = ReadBit(vbExpandOut0);
			expandOut |= ReadBit(vbExpandOut1) << 1;
			expandOut |= ReadBit(vbExpandOut2) << 2;
			expandOut |= ReadBit(vbExpandOut3) << 3;
			expandOut |= ReadBit(vbExpandOut4) << 4;
			expandOut |= ReadBit(vbExpandOut5) << 5;
			expandOut |= ReadBit(vbExpandOut6) << 6;
			expandOut |= ReadBit(vbExpandOut7) << 7;
			//expandOut = expandIn; // Test
			ClearBit(pIO_SS);		
			expandIn = SPI_IO_OUT(expandOut);
			SetBit(pIO_SS);	
			(expandIn & 0x01) ? SetBit(vbExpandIn0) : ClearBit(vbExpandIn0);
			(expandIn & 0x02) ? SetBit(vbExpandIn1) : ClearBit(vbExpandIn1);
			(expandIn & 0x04) ? SetBit(vbExpandIn2) : ClearBit(vbExpandIn2);
			(expandIn & 0x08) ? SetBit(vbExpandIn3) : ClearBit(vbExpandIn3);
			(expandIn & 0x10) ? SetBit(vbExpandIn4) : ClearBit(vbExpandIn4);
			(expandIn & 0x20) ? SetBit(vbExpandIn5) : ClearBit(vbExpandIn5);
			(expandIn & 0x40) ? SetBit(vbExpandIn6) : ClearBit(vbExpandIn6);
			(expandIn & 0x80) ? SetBit(vbExpandIn7) : ClearBit(vbExpandIn7);
		}
		
		if (ReadBit(vbHomeRunning))	// Disable Jog during Homing Routine
			continue;

		// Re-Sync Slave Servo to Master Servo when Re-Enabled
		if (ReadBit(vbMachineHomed) && ReadBit(vbDriveEnable) && (persist.UserData[pdSlaveATo] > 0))
		{			
			slavePos[0] = GetPos(A);
			masterPos[0] = GetPos(chan[A].MasterAxis);
			if (slavePos[0] != masterPos[0])
			{
				if (abs(slavePos[0] - masterPos[0]) < SLAVE_RESYNC_TOLERANCE)
					Move(A, masterPos[0]);
			}
			ClearBit(vbDriveEnable);
		}

		// Jog using virtual bits
		ChkBitJog(X, vbJogX_Neg, vbAtLimitXLo);	
		ChkBitJog(Y, vbJogY_Neg, vbAtLimitYLo);	
		ChkBitJog(Z, vbJogZ_Neg, vbAtLimitZLo);	
		ChkBitJog(A, vbJogA_Neg, vbAtLimitALo);	

		// Check softlimit for Jog() Command and during GCode running
		if (ReadBit(vbSoftlimitEn))
		{
			// Check Limit for all axis
			for (i = 0; i < 3; i++) 
			{
				if ((isMoving[i] == 0) && (atLimit[i] == 0))	// If Bit Joging, don't Check
				{
					delta[i] = (GetPos(i) - savLastPos[i]);
					if ((int)GetPos(i) > (int)softLimitHi[i])
					{
						if (delta[i] > 4)
							Disable(i);		
					}
					else if ((int)GetPos(i) < (int)softLimitLo[i])
					{
						if (delta[i] < -4)
							Disable(i);											
					}		
					savLastPos[i] = GetPos(i);
				}
			}
			Delay_sec(0.005);
		}		
	}
}	

//-----------------------------------------------------------------
void ChkBitJog(int axis, int bitAddress, int atlimitBit)
{			
	double limitBufferZone;	 
	int limitZoneLo[6];
	int limitZoneHi[6];
	int currPos;	
	double speedCalc;
	double vx, vy;

	WaitNextTimeSlice();  // ensure we don't get interrupted
	vx = (ch0->Dest - ch0->last_dest) * (1.0f/TIMEBASE);
	vy = (ch1->Dest - ch1->last_dest) * (1.0f/TIMEBASE);
	speedCalc = sqrtf(vx*vx+vy*vy);

	limitBufferZone = speedCalc * (pow(currentSpeed,0.05)-1.445); 
	//limitBufferZone = currentSpeed * (pow(currentSpeed,0.05)-1.445); 

	limitZoneLo[axis] = softLimitLo[axis] + (int)limitBufferZone;
	limitZoneHi[axis] = softLimitHi[axis] - (int)limitBufferZone;

	// Check if softLimit hit
	if (ReadBit(vbSoftlimitEn))
	{
		currPos = (int)chan[axis].Dest;
	  if (currPos <= limitZoneLo[axis])
	  {
			atLimit[axis] = LIMIT_LO;
			SetBit(atlimitBit);
		}
		else if (currPos >= limitZoneHi[axis])
		{
			atLimit[axis] = LIMIT_HI;
			SetBit(atlimitBit + 1);
		}
		else
			atLimit[axis] = LIMIT_SAFE;
	}
	else
			atLimit[axis] = LIMIT_SAFE;

	if (atLimit[axis] == LIMIT_SAFE)
	{
		ClearBit(atlimitBit);
		ClearBit(atlimitBit + 1);			
	}

	// Check if Jog bit has been set
	if (isMoving[axis] == 0)
	{		
		if (ReadBit(bitAddress) && (atLimit[axis] != LIMIT_LO))
		{
			//printf("Jog-- softLimitL: %d BufferZone: %f LoZone:%d, HiZone:%d \n", (int)softLimitLo[axis], (float)limitBufferZone, (int)limitZoneLo[axis], (int)limitZoneHi[axis]);
			Jog(axis, -currentSpeed);
			isMoving[axis] = -1;
		}
		else if (ReadBit(bitAddress+1) && (atLimit[axis] != LIMIT_HI))
		{
			//printf("Jog++ softLimitH: %d BufferZone: %f LoZone:%d, HiZone:%d \n", (int)softLimitHi[axis], (float)limitBufferZone, (int)limitZoneLo[axis], (int)limitZoneHi[axis]);
			Jog(axis, currentSpeed);
			isMoving[axis] = 1;
		}
	}
	else
	{		
		if (!ReadBit(bitAddress) && !ReadBit(bitAddress+1))
		{
			Jog(axis, 0);
			isMoving[axis] = 0;
		}
		else
		{
			if ((isMoving[axis] == -1) && (atLimit[axis] == LIMIT_LO))
			{
				Jog(axis, 0);
				while(!CheckDone(axis))
					;
				Move(axis, (int)softLimitLo[axis]);

				isMoving[axis] = 0;
				//printf("Limit Lo\n");
			}
			else if ((isMoving[axis] == 1) && (atLimit[axis] == LIMIT_HI))
			{
				Jog(axis, 0);
				while(!CheckDone(axis))
					;
				Move(axis, (int)softLimitHi[axis]);

				isMoving[axis] = 0;
				//printf("Limit Hi\n");
			}
		}
	}
}

//---------------------------------------------------------
int SPI_IO_Init()
{
	SetBitDirection(pIO_MOSI,1);
	SetBitDirection(pIO_MISO,0);
	SetBitDirection(pIO_SCK,1);
	SetBitDirection(pIO_SS,1);
}

//---------------------------------------------------------
// SPI Mode 0, MSB first
int SPI_IO_OUT(int data)
{
	int i;
	int dataIn;
	
	dataIn = 0;

	for (i = 0; i < 8; i++)
	{
		if (data & 0x80)	// look at high bit
			SetBit(pIO_MOSI);
		else
			ClearBit(pIO_MOSI);
		data = data << 1;

		SetBit(pIO_SCK);
		
		dataIn = dataIn << 1;
		if (ReadBit(pIO_MISO))
			dataIn |= 0x01;
				
		ClearBit(pIO_SCK);	
	}
	
	return dataIn;
}