#include "KMotionDef.h"

double T0,T1,Delta;

// A User Program Call Back can be defined to be called every Servo Sample
// Set to Non-NULL for the the Callback to be made.  The Call Back Routine
// must retuen with a few micro seconds or the system may become unstable
typedef void USERCALLBACK(void);
extern USERCALLBACK *UserCallBack;


void CallBack(void)
{
	T0=Time_sec();
	Delta = T0-T1;
	T1=T0;
}

main()
{
	int i;

	// disable the Call Back	
	UserCallBack = NULL;
	
	PauseThread(1); // Stop running thread
	PauseThread(2); // Stop running thread
	PauseThread(3); // Stop running thread
	PauseThread(4); // Stop running thread
	PauseThread(5); // Stop running thread
	PauseThread(6); // Stop running thread

	ClearBit(24);	// Turn off Drive Active
	ClearBit(25);
	
	ClearBit(63);	// Init bit for V1
	ClearBit(1024);	// Init bit for V2
	
	Delay_sec(.5);
	
}


