﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace PostProcessExtruder
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        Settings1 Settings = new Settings1();

        public MainWindow()
        {
            InitializeComponent();
            InputFile_textBox.Text = Settings.InputFile;
            OutputFile_textBox.Text = Settings.OutputFile;
        }

        private void InputFileButton_Click(object sender, RoutedEventArgs e)
        {
            // Create OpenFileDialog 
            Microsoft.Win32.OpenFileDialog dlg = new Microsoft.Win32.OpenFileDialog();

            // Set filter for file extension and default file extension 
            dlg.DefaultExt = ".gcode";
            dlg.Filter = "Craftware GCode Files (*.gcode)|*.gcode|All Files (*.*)|*.*";


            // Display OpenFileDialog by calling ShowDialog method 
            Nullable<bool> result = dlg.ShowDialog();


            // Get the selected file name and display in a TextBox 
            if (result == true)
            {
                // Open document 
                Settings.InputFile = InputFile_textBox.Text = dlg.FileName;
                Settings.Save();

            }
        }

        private void OutputFileButton_Click(object sender, RoutedEventArgs e)
        {
            Microsoft.Win32.SaveFileDialog dlg = new Microsoft.Win32.SaveFileDialog();


            dlg.FileName = System.IO.Path.ChangeExtension(InputFile_textBox.Text, ".ngc");
            dlg.DefaultExt = ".ngc"; // Default file extension
            dlg.Filter = "GCode Files (.ngc)|*.ngc"; // Filter files by extension

            // Show save file dialog box
            Nullable<bool> result = dlg.ShowDialog();

            // Process save file dialog box results
            if (result == true)
            {
                // Save document
                Settings.OutputFile = OutputFile_textBox.Text = dlg.FileName;
                Settings.Save();
            }
        }

        private void ProcessButton_Click(object sender, RoutedEventArgs EventArgs)
        {
            StreamReader file = new StreamReader(InputFile_textBox.Text);
            StreamWriter outfile = new StreamWriter(OutputFile_textBox.Text);

            try
            {
                bool xflag=false, yflag=false, zflag=false, eflag=false, fflag=false, gflag = false, sflag = false;
                double x=0, y=0, z=0, e=0, f=0, g=0, s=0, px=0, py=0, pz=0, pe=0, pf=0, pg=0, de, dx, dy, dz;

                while (!file.EndOfStream)
                {
                    string sright,sleft;
                    string sin = file.ReadLine();

                    if (sin != "")
                    {
                        // extract any comment
                        int i = sin.IndexOf(";");
                        if (i >= 0)
                        {
                            sright = sin.Remove(0, i + 1);
                            sleft = sin.Remove(i, sin.Length - i);

                            // remove any '(' or ')'
                            sright = sright.Replace("(", "");
                            sright = sright.Replace(")", "");

                            if (sright.Length > 100) sright = sright.Remove(100, sright.Length-100);

                        }
                        else
                        {
                            sright = "";
                            sleft = sin;
                        }

                        CommentOutMCode(ref sleft, "M106");
                        CommentOutMCode(ref sleft, "M190");
                        CommentOutMCode(ref sleft, "M109");
                        CommentOutMCode(ref sleft, "M140");

                        string r = "";
                        ReplaceWord('E', 'U', sleft, ref sleft, ref eflag, ref e);

                        if (sright.Length > 0)
                            sin = sleft + '(' + sright + ')';
                        else
                            sin = sleft;

                        outfile.WriteLine(sin);
                    }
                }
                outfile.WriteLine("G91Z10\n");
                outfile.WriteLine("G90X-30Y-30\n");
                outfile.WriteLine("M30\n");
                file.Close();
                outfile.Close();
            }
            catch (IOException)
            {
                MessageBox.Show("IO Exception Processing Files");

                file.Close();
                outfile.Close();
            }
        }

        private static double DoChange(bool eflag, double e, ref double pe)
        {
            double de;
            // determine extruder motion
            if (eflag)
            {
                de = e - pe;
                pe = e;
            }
            else
                de = 0.0;
            return de;
        }

        private int ExtractWord(char w, string s, ref string r, ref bool flag, ref double x)
        {
            int n;
            string su = s.ToUpper();

            flag = false;
            int i = su.IndexOf(w.ToString());
            if (i >= 0)  // found?
            {
                // find the end of the number
                for (n = i + 1; n < su.Length; n++) // skip leading whitespace
                    if (Char.IsWhiteSpace(su[i])) break;
                int i2 = n; // save starting point after whitespace
                for (; n < su.Length; n++)
                    if (Char.IsDigit(su[i]) && su[i] != '+' && su[i] != '-' && su[i] != '.') break;

                string v = s.Substring(i2, n - i);
                r = s.Remove(i, n - i);
                if (!Double.TryParse(v, out x)) return 1;
                flag = true;
                return 0;
            }

            return 0;
        }

        private int ReplaceWord(char w, char w2, string s, ref string r, ref bool flag, ref double x)
        {
            int n;
            string su = s.ToUpper();
            r = s;
            flag = false;
            int i = su.IndexOf(w.ToString());
            if (i >= 0)  // found?
            {
                r=r.Replace(w,w2);
                flag = true;
            }

            return 0;
        }


        private void CommentOutMCode(ref string s, string v)
        {
            s = s.Replace(v, '(' + v + ')');
        }
    }
}
