/****************************************************************************/
/*  assert   v7.4.24                                                        */
/*                                                                          */
/* Copyright (c) 1993-2018 Texas Instruments Incorporated                   */
/* http://www.ti.com/                                                       */
/*                                                                          */
/*  Redistribution and  use in source  and binary forms, with  or without   */
/*  modification,  are permitted provided  that the  following conditions   */
/*  are met:                                                                */
/*                                                                          */
/*     Redistributions  of source  code must  retain the  above copyright   */
/*     notice, this list of conditions and the following disclaimer.        */
/*                                                                          */
/*     Redistributions in binary form  must reproduce the above copyright   */
/*     notice, this  list of conditions  and the following  disclaimer in   */
/*     the  documentation  and/or   other  materials  provided  with  the   */
/*     distribution.                                                        */
/*                                                                          */
/*     Neither the  name of Texas Instruments Incorporated  nor the names   */
/*     of its  contributors may  be used to  endorse or  promote products   */
/*     derived  from   this  software  without   specific  prior  written   */
/*     permission.                                                          */
/*                                                                          */
/*  THIS SOFTWARE  IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS   */
/*  "AS IS"  AND ANY  EXPRESS OR IMPLIED  WARRANTIES, INCLUDING,  BUT NOT   */
/*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR   */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT   */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,   */
/*  SPECIAL,  EXEMPLARY,  OR CONSEQUENTIAL  DAMAGES  (INCLUDING, BUT  NOT   */
/*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,   */
/*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY   */
/*  THEORY OF  LIABILITY, WHETHER IN CONTRACT, STRICT  LIABILITY, OR TORT   */
/*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE   */
/*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.    */
/*                                                                          */
/****************************************************************************/
#include <stdio.h>
#include <assert.h>
#include <stdlib.h>

/****************************************************************************/
/* _ASSERT() - Implements the assert macro. Checks the argument. Aborts     */
/*             with a message if not true.                                  */
/****************************************************************************/
_CODE_ACCESS void _assert(int expr, const char *string)
{
#if defined(__TMS320C6X__) && defined(__TI_EABI__)
    if (!expr) __c6xabi_abort_msg(string);
#else
    if (!expr) _abort_msg(string);
#endif
}

/****************************************************************************/
/* _NASSERT() - Special version of assert, which assumes the expression is  */
/*              true.                                                       */
/****************************************************************************/
_CODE_ACCESS void _nassert(int expr)
{
    return;
}

/****************************************************************************/
/* _ABORT_MSG() - Write out a string and never return.  Abort function for  */
/*                false assertions.                                         */
/****************************************************************************/
#if defined(__TMS320C6X__) && defined(__TI_EABI__)
#pragma FUNC_EXT_CALLED(__c6xabi_abort_msg)
_CODE_ACCESS void __c6xabi_abort_msg(const char *string)
#else
#pragma FUNC_EXT_CALLED(_abort_msg)
_CODE_ACCESS void _abort_msg(const char *string)
#endif
{
    fprintf(stderr,"%s",string);
    fflush(stderr); /* Always a good idea to flush */
    abort();
}
