/****************************************************************************/
/*  fixdli.c         v7.4.24                                                */
/*                                                                          */
/* Copyright (c) 1997-2018 Texas Instruments Incorporated                   */
/* http://www.ti.com/                                                       */
/*                                                                          */
/*  Redistribution and  use in source  and binary forms, with  or without   */
/*  modification,  are permitted provided  that the  following conditions   */
/*  are met:                                                                */
/*                                                                          */
/*     Redistributions  of source  code must  retain the  above copyright   */
/*     notice, this list of conditions and the following disclaimer.        */
/*                                                                          */
/*     Redistributions in binary form  must reproduce the above copyright   */
/*     notice, this  list of conditions  and the following  disclaimer in   */
/*     the  documentation  and/or   other  materials  provided  with  the   */
/*     distribution.                                                        */
/*                                                                          */
/*     Neither the  name of Texas Instruments Incorporated  nor the names   */
/*     of its  contributors may  be used to  endorse or  promote products   */
/*     derived  from   this  software  without   specific  prior  written   */
/*     permission.                                                          */
/*                                                                          */
/*  THIS SOFTWARE  IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS   */
/*  "AS IS"  AND ANY  EXPRESS OR IMPLIED  WARRANTIES, INCLUDING,  BUT NOT   */
/*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR   */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT   */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,   */
/*  SPECIAL,  EXEMPLARY,  OR CONSEQUENTIAL  DAMAGES  (INCLUDING, BUT  NOT   */
/*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,   */
/*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY   */
/*  THEORY OF  LIABILITY, WHETHER IN CONTRACT, STRICT  LIABILITY, OR TORT   */
/*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE   */
/*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.    */
/*                                                                          */
/****************************************************************************/

#include "double_config.h"
#include "reald.h"

#include "ieeemask.h"

#if !(defined(__TMS320C6X__) && defined(__TI_EABI__)) && (BPlong == BPint)
   __EXTERN int _fixdi(double x);
   long _fixdli(double x) { return (long)_fixdi(x); }
#else
   /*------------------------------------------------------------------------*/
   /* For C6x EABI, the compiler helper functions which are named as though  */
   /* they operated on "long int" or "unsigned long" are actually            */
   /* re-purposed to handle "__int4_t" and "unsigned __int40_t" values.      */
   /*------------------------------------------------------------------------*/
   #if defined(__TMS320C6X__) && defined(__TI_EABI__)
      #define SIGNED __int40_t
      #define UNSIGN unsigned __int40_t
      #define BPSIGNED 40
   #else
      #define SIGNED long
      #define UNSIGN unsigned long
      #define BPSIGNED BPlong
   #endif
   #define FIXFx _fixdli
   #include "fixfx_i.h"
#endif
