/*****************************************************************************/
/* cxxabi.h v7.4.24                                                          */
/* Copyright (c) 1996-2018 Texas Instruments Inc., all rights reserved       */
/*****************************************************************************/
/******************************************************************************
*                                                             \  ___  /       *
*                                                               /   \         *
* Edison Design Group C++  Runtime                           - | \^/ | -      *
* Copyright 1993-2004 Edison Design Group, Inc.                 \   /         *
* All rights reserved.  Consult your license regarding        /  | |  \       *
* permissions and restrictions.                                  [_]          *
*                                                                             *
******************************************************************************/
/*
cxxabi.h -- Include file for IA-64 ABI entry points.
*/

#ifndef __CXXABI_H
#define __CXXABI_H

#ifndef __STDDEF_H
#include <stddef.h>
#endif  /* ifndef __STDDEF_H */
#include <typeinfo>

#ifdef __EDG_RUNTIME_USES_NAMESPACES
namespace __cxxabiv1 {
  using namespace std;
#endif /* ifdef __EDG_RUNTIME_USES_NAMESPACES */

  /* type_info implementation classes */

#pragma define_type_info
  class __fundamental_type_info : public type_info {
  public:
    virtual ~__fundamental_type_info();
  };

#pragma define_type_info
  class __array_type_info : public type_info {
  public:
    virtual ~__array_type_info();
  };

#pragma define_type_info
  class __function_type_info : public type_info {
  public:
    virtual ~__function_type_info();
  };

#pragma define_type_info
  class __enum_type_info : public type_info {
  public:
    virtual ~__enum_type_info();
  };

#pragma define_type_info
  class __class_type_info : public type_info {
  public:
    virtual ~__class_type_info();
  };

#pragma define_type_info
  class __si_class_type_info : public __class_type_info {
  public:
    virtual ~__si_class_type_info();
    const __class_type_info *__base_type;
  };

  struct __base_class_type_info {
    const __class_type_info *__base_type;
    long __offset_flags;

    enum __offset_flags_masks {
      __virtual_mask = 0x1,
      __public_mask = 0x2,
      __offset_shift = 8
    };
  };

#pragma define_type_info
  class __vmi_class_type_info : public __class_type_info {
  public:
    virtual ~__vmi_class_type_info();
    unsigned int __flags;
    unsigned int __base_count;
    __base_class_type_info __base_info[1];

    enum __flags_masks {
      __non_diamond_repeat_mask = 0x1,
      __diamond_shaped_mask = 0x2
    };
  };

#pragma define_type_info
  class __pbase_type_info : public type_info {
  public:
    virtual ~__pbase_type_info();
    unsigned int __flags;
    const type_info *__pointee;
    
    enum __masks {
      __const_mask = 0x1,
      __volatile_mask = 0x2,
      __restrict_mask = 0x4,
      __incomplete_mask = 0x8,
      __incomplete_class_mask = 0x10
    };
  }; 

#pragma define_type_info
  class __pointer_type_info : public __pbase_type_info {
    virtual ~__pointer_type_info();
  };

#pragma define_type_info
  class __pointer_to_member_type_info : public __pbase_type_info {
    virtual ~__pointer_to_member_type_info();
    const __class_type_info *__context;
  };

  extern "C" {
    /* Pure virtual function calls. */
    void __cxa_pure_virtual();
  
    /* Guard variables for the initialization of variables with static storage
       duration. */
#if defined(__EDG_IA64_ABI_USE_INT_STATIC_INIT_GUARD)
    /*------------------------------------------------------------------------*/
    /* ARM EABI specifies that guard variables are 4 bytes long               */
    /* Also, type of parameter passed to these functions is int*              */
    /* C++ ABI for the ARM Architecture, Section 3.1                          */
    /*------------------------------------------------------------------------*/
    int  __cxa_guard_acquire(int *);
    void __cxa_guard_release(int *);
    void __cxa_guard_abort  (int *);
#elif defined(__EDG_IA64_ABI_USE_VARIANT_INT_STATIC_INIT_GUARD)
    /*-----------------------------------------------------------------------*/
    /* C6x ELF ABI specifies that guard variables are 4 bytes. IA64 C++ ABI  */
    /* uses 64-bits. The One time construction API under C6x ELF ABI uses    */
    /* unsigned int * as the pararmeter, accordingly.                        */
    /*-----------------------------------------------------------------------*/
    int  __cxa_guard_acquire(unsigned int *);
    void __cxa_guard_release(unsigned int *);
    void __cxa_guard_abort  (unsigned int *);
#else
    int  __cxa_guard_acquire(unsigned long long *);
    void __cxa_guard_release(unsigned long long *);
    void __cxa_guard_abort  (unsigned long long *);
#endif

    /* Construction and destruction of arrays. */
#ifdef __EDG_IA64_ABI_VARIANT_CTORS_AND_DTORS_RETURN_THIS
    /*------------------------------------------------------------------------*/
    /* ARM EABI specifies that ctors/dtors return "this", update function     */
    /* pointers to correspond                                                 */
    /* C++ ABI for the ARM Architecture, Section 3.1                          */
    /*------------------------------------------------------------------------*/
    /* C6x ELF ABI also requires that ctors/dtors return this pointer .       */
    /*------------------------------------------------------------------------*/
    void *__cxa_vec_new(size_t, size_t, size_t, void *(*)(void *),
                        void *(*)(void *));
    void *__cxa_vec_new2(size_t, size_t, size_t, void *(*)(void *),
                         void *(*)(void *), void *(*)(size_t),
                         void (*)(void *));
    void *__cxa_vec_new3(size_t, size_t, size_t, void *(*)(void *),
                         void *(*)(void *), void *(*)(size_t),
                         void (*)(void *, size_t));
    void *__cxa_vec_ctor(void *, size_t, size_t, void *(*)(void *),
                        void *(*)(void *));
    void __cxa_vec_dtor(void *, size_t, size_t, void *(*)(void *));
    void __cxa_vec_cleanup(void *, size_t, size_t, void *(*)(void *));
    void __cxa_vec_delete(void *, size_t, size_t, void *(*)(void *));
    void __cxa_vec_delete2(void *, size_t, size_t, void *(*)(void *),
                           void (*)(void *));
    void __cxa_vec_delete3(void *, size_t, size_t, void *(*)(void *),
                           void (*)(void *, size_t));
    void *__cxa_vec_cctor(void *, void *, size_t, size_t, 
                         void *(*)(void *, void *), void *(*)(void *));
#else
    void *__cxa_vec_new(size_t, size_t, size_t, void (*)(void *),
                        void (*)(void *));
    void *__cxa_vec_new2(size_t, size_t, size_t, void (*)(void *),
                         void (*)(void *), void *(*)(size_t),
                         void (*)(void *));
    void *__cxa_vec_new3(size_t, size_t, size_t, void (*)(void *),
                         void (*)(void *), void *(*)(size_t),
                         void (*)(void *, size_t));
    void __cxa_vec_ctor(void *, size_t, size_t, void (*)(void *),
                        void (*)(void *));
    void __cxa_vec_dtor(void *, size_t, size_t, void (*)(void *));
    void __cxa_vec_cleanup(void *, size_t, size_t, void (*)(void *));
    void __cxa_vec_delete(void *, size_t, size_t, void (*)(void *));
    void __cxa_vec_delete2(void *, size_t, size_t, void (*)(void *),
                           void (*)(void *));
    void __cxa_vec_delete3(void *, size_t, size_t, void (*)(void *),
                           void (*)(void *, size_t));
    void __cxa_vec_cctor(void *, void *, size_t, size_t, 
                         void (*)(void *, void *), void (*)(void *));
#endif
    /* Finalization. */
    int __cxa_atexit(void (*)(void *), void *, void *);
    void __cxa_finalize(void *);

/*** START TI ADD ***/
    void __cxa_ia64_exit(int status);
/*** END TI ADD ***/

    /* Exception-handling support. */
    void __cxa_bad_cast();
    void __cxa_bad_typeid();

    /* Demangling interface. */
    char *__cxa_demangle(const char* __mangled_name,
                         char        *__buf,
                         size_t      *__n,
                         int         *__status);

/*** START TI ADD ***/
    void *__dynamic_cast(void		                     *class_ptr,
                         const __cxxabiv1::__class_type_info *source_tiip,
                         const __cxxabiv1::__class_type_info *tiip,
                         std::ptrdiff_t                       hint);
/*** END TI ADD ***/
  }  /* extern "C" */
#ifdef __EDG_RUNTIME_USES_NAMESPACES
}  /* namespace __cxxabiv1 */

/* Create the "abi" namespace alias. */
namespace abi = __cxxabiv1;
#endif /* ifdef __EDG_RUNTIME_USES_NAMESPACES */

#ifdef __TI_EABI_SUPPORT__
namespace __aeabiv1 {
/* EABI parameter order: object ptr, dtor ptr, dso handle */
extern "C" int __aeabi_atexit(void *, void (*)(void *), void *);
}  /* namespace __aeabiv1 */
#endif

#endif /* ifndef __CXXABI_H */

/******************************************************************************
*                                                             \  ___  /       *
*                                                               /   \         *
* Edison Design Group C++  Runtime                           - | \^/ | -      *
* Copyright 1993-2004 Edison Design Group, Inc.                 \   /         *
* All rights reserved.  Consult your license regarding        /  | |  \       *
* permissions and restrictions.                                  [_]          *
*                                                                             *
******************************************************************************/
