// TrajectoryPlanner.h  Tom Kerekes 09/11/02
/*********************************************************************/
/*         Copyright (c) 2003-2006  DynoMotion Incorporated          */
/*********************************************************************/


enum {SEG_LINEAR,SEG_ARC};

#define MAX_TP_SEGMENTS 40000 

#define DIR_CCW true
#define DIR_CW false

typedef struct  // 2nd order polynomial for a single trip state
{
	double t;   // time duration (in sec) of trip state
	double a;   // t^2 coefficient  (acceleration)
	double b;   // t^1 coefficient  (initial velocity)
	double c;   // t^0 constant coefficient (starting position)
} TP_COEFF;


typedef struct
{
	double dx;			// path length of segment
	double MaxVel,OrigVel;
	double MaxAccel,MaxDecel;
	double vel;          // beginning velocity of segment
	BOOL Done;			// segment's ending vel can't ever be increased,
						// (it is either: at the MaxVel, or the entire segment 
						// is at MaxAccel and the prev segment is Done)
	TP_COEFF C[3];      // polynomials for accel, const vel, decel

	int type;           // SEG_LINEAR or SEG_ARC
	double x0,y0,z0,a0; // starting point
	double x1,y1,z1,a1; // ending point
	double xc,yc;		// center (if arc)
	BOOL DirIsCCW;			
	double ChangeInDirection;  // angle from previous seg to this one
} SEGMENT;

extern double BreakAngle;  // amount of change in direction where we need to stop

extern int nsegs;
extern SEGMENT segments[MAX_TP_SEGMENTS];

#define MAX_SPECIAL_CMDS 1000

// special commands such as SetBit that should occur along the path

typedef struct
{
	int seg_before;   // Special command goes before this seg number 0 at beginning
	char cmd[MAX_LINE];
} SPECIAL_CMD;


extern int nspecial_cmds;
extern SPECIAL_CMD special_cmds[MAX_SPECIAL_CMDS];
extern int ispecial_cmd_downloaded;


// initialize for new list of segments
// define endpoint to have zero vel

void tp_init(double tol);

// insert new segment at the end.  Re-evaluate backwards
// through list to see if velocities could be increased

int tp_insert_linear_seg(double x0, double y0, double z0, double a0, 
						 double x1, double y1, double z1, double a1, 
						 double MaxVel, double MaxCombineLength);

int tp_insert_arc_seg(double x0, double y0, double z0, 
					  double x1, double y1, double z1, 
					  double xc, double yc, BOOL DirIsCCW,
					  double MaxVel, double MaxAccel, double MaxDecel);

double CalcLengthAlongHelix(double x0, double y0, double z0, 
					  double x1, double y1, double z1, 
					  double xc, double yc, BOOL DirIsCCW, 
					  double *radius, double *theta0, double *dtheta);


// calculate the trip states (three 2nd order polynomials)
// for a segment given the initial and ending velocities

int tp_calc_seg_trip_states(int i);

// Maximize what we have so far assuming a stop at the end
void MaximizeSegments();

void SetSegmentVelAccels(int i, double Vel, double Accel, double Decel);
void GetSegmentDirection(int i, double *dx, double *dy, double *dz, double *da);
