// Kinematics.h: interface for the CKinematics class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_KINEMATICS_H__F0E3BA96_734F_4D32_85DD_8B2FA813C991__INCLUDED_)
#define AFX_KINEMATICS_H__F0E3BA96_734F_4D32_85DD_8B2FA813C991__INCLUDED_


#ifdef GCODEINTERPRETER_EXPORTS
#define GCODEINTERPRETER_API __declspec(dllexport)
#else
#define GCODEINTERPRETER_API __declspec(dllimport)
#endif


#include "PT2D.h"
#include "PT3D.h"



#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#define MAX_ACTUATORS 4


typedef struct
{
	double	BreakAngle;
	double	CollinearTol;
	double	TPLookahead;
	double	MaxAccelA;
	double	MaxAccelX;
	double	MaxAccelY;
	double	MaxAccelZ;
	double	MaxVelA;
	double	MaxVelX;
	double	MaxVelY;
	double	MaxVelZ;
	double	CountsPerInchA;
	double	CountsPerInchX;
	double	CountsPerInchY;
	double	CountsPerInchZ;
	double	MaxLinearLength;
} MOTION_PARAMS; 


class GCODEINTERPRETER_API CKinematics  
{
public:
	void Solve(double *A, int N);
	int MaxAccelInDirection(double dx, double dy, double dz, double da, double *accel);
	int MaxRateInDirection(double dx, double dy, double dz, double da, double *rate);
	virtual int TransformCADtoActuators(double x, double y, double z, double a, double *Acts);
	virtual int TransformActuatorstoCAD(double *Acts, double *x, double *y, double *z, double *a);

	int IntersectionTwoCircles(CPT2D c0, double r0, CPT2D c1, double r1, CPT2D *q);

	int ReadGeoTable(const char *name);
	int GeoCorrect(double x, double y, double z, double *cx, double *cy, double *cz);

	
	CKinematics();
	virtual ~CKinematics();

	MOTION_PARAMS m_MotionParams;


	bool GeoTableValid;
	CPT3D *GeoTable;
	CString *Table2;
	int NRows,NCols;
	double GeoSpacingX,GeoSpacingY;

};

#endif // !defined(AFX_KINEMATICS_H__F0E3BA96_734F_4D32_85DD_8B2FA813C991__INCLUDED_)
