// GCodeInterpreter.h  --  KMotion G Code Interpreter DLL Interface class
/*********************************************************************/
/*         Copyright (c) 2003-2006  DynoMotion Incorporated          */
/*********************************************************************/



#include "CoordMotion.h"
#include "rs274ngc.h"
/*

int Interpret(int board,
              char *fname,
              int start, int end,
              int restart,
              G_COMPLETE_CALLBACK CompleteFn,
              G_STATUS_CALLBACK StatusFn);



Internally this function creates a thread and begins interpreting the
specified file of GCode beginning at the specified file start line number
(0=beginning of file) and proceeds upto and including the specified end line
number (-1=entire file).  If the restart flag is specified, the Interpreter
will be re-initialized, otherwise it will resume in its present state.  The
function returns immediately after creating the thread that will be used to
interpret the GCode.  As the GCode is interpreted any generated commands
will be sent to the specified KMotion board after possibly being passed
through the Trajectory Planner.  Status Strings which describe the types of
commands generated by the interpreter may be passed back to the caller via
the StatusFn callback.  When completed (or on an error) the CompleteFn
Callback may be made with a status code indicating success or error.  If
there is an error, the offending line number and an error string will also
be passed.  If either callback is specified as NULL, then the respective
callback(s) will not be made.

Return Value:

0 = success, 1 = failure


Parameters:

int board

	specifies KMotion board to send commands to

char *fname

	GCode FileName

int start

	Starting line number 0 = beginning of file

int end,

	End line number -1 = beginning of file
	same as start will execute one line

                     int restart,
                     COMPLETE_CALLBACK CompleteFn,
                     STATUS_CALLBACK StatusFn);


*/

#if !defined(GCODEINTERPRETER_H)
#define GCODEINTERPRETER_H

#pragma warning(disable: 4275)
#pragma warning(disable: 4251)



typedef void G_COMPLETE_CALLBACK(int status, int line_no, const char *err);
typedef void G_STATUS_CALLBACK(int line_no, const char *msg);



// Misc Commands (M Code) within GCode are normally used
// for spindle on/off and such.  In general any M Code
// may be mapped to various KMotion "Actions" such as
//

enum { 
	M_Action_None = 0,       // do nothing 
	M_Action_Setbit = 1,     // Set a bit high or low
	M_Action_SetTwoBits = 2, // Set two bits either high or low
	M_Action_DAC = 3,        // output a value to a DAC
	M_Action_Program = 4,    // run a KMotion User C program   
};

#define MAX_MCODE_ACTIONS 16
#define MAX_MCODE_DOUBLE_PARAMS 5

// This structure defines the action and 
// parameters for a particular MCode Action

typedef struct
{
	int Action;
	double dParams[MAX_MCODE_DOUBLE_PARAMS];
	char String[256];
} MCODE_ACTION; 



// This class is exported from the GCodeInterpreter.dll

class GCODEINTERPRETER_API CGCodeInterpreter {
public:
	int ChangeFixtureNumber(int fixture);
	
	double InchesToUserUnits(double inches);
	double UserUnitsToInches(double inches);
	double ConvertAbsToUserUnitsX(double x);
	double ConvertAbsToUserUnitsY(double y);
	double ConvertAbsToUserUnitsZ(double z);
	double ConvertAbsToUserUnitsA(double a);

	int InvokeAction(int i, BOOL FlushBeforeUnbufferedOperation=TRUE);
	CGCodeInterpreter(void);
	virtual ~CGCodeInterpreter();

	int Interpret(int board,
		          const char *fname,
			      int start, int end,
				  int restart,
                  G_STATUS_CALLBACK *StatusFn,
				  G_COMPLETE_CALLBACK *CompleteFn);


	MCODE_ACTION McodeActions[MAX_MCODE_ACTIONS];
	
	MOTION_PARAMS *GetMotionParams();  // returns a pointer to the GCode Parameters

	char ToolFile[MAX_PATH];
	char SetupFile[MAX_PATH];
	char GeoFile[MAX_PATH];

	CCoordMotion CoordMotion;
	bool m_Halt;
	int m_CurrentLine;
	int m_GCodeReads;
	CString m_InFile;
	int m_exitcode;
	int DoExecute();
	int DoExecuteComplete();

	void SetToolFile(char *f);
	void SetSetupFile(char *f);

	int ReadSetupFile();

	void Halt();
	bool GetHalt();
	void Abort();
	bool GetAbort();

	setup_pointer p_setup;
	bool m_InitializeOnExecute;

private:

	char *m_fname;
	int m_start, m_end;
	int m_restart;
	G_COMPLETE_CALLBACK *m_CompleteFn;
    G_STATUS_CALLBACK *m_StatusFn;

	int rs274ErrorExit(int status);
	int LaunchExecution();

};

extern CCoordMotion *CM;
extern CGCodeInterpreter *GC;


#endif

