// CoordMotion.h: interface for the CCoordMotion class.
/*********************************************************************/
/*         Copyright (c) 2003-2006  DynoMotion Incorporated          */
/*********************************************************************/



#if !defined(AFX_COORDMOTION_H_INCLUDED_)
#define AFX_COORDMOTION_H_INCLUDED_

#include "KMotionDLL.h"
#include "TrajectoryPlanner.h"
#include "Kinematics.h"	// Added by ClassView


#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000



typedef void STRAIGHT_TRAVERSE_CALLBACK(double x, double y, double z, double a);

typedef void STRAIGHT_FEED_CALLBACK(double DesiredFeedRate_in_per_sec,
							   double x, double y, double z, double a);

typedef void ARC_FEED_CALLBACK(double DesiredFeedRate_in_per_sec, 
				double first_end, double second_end, 
		        double first_axis, double second_axis, int rotation,
				double axis_end_point,
				double first_start, double second_start, double axis_start_point);


class GCODEINTERPRETER_API CCoordMotion  
{
public:
	CKinematics *Kinematics;
	void DownloadInit();
	int ExecutionStop();
	double GetFeedRateOverride();
	void SetFeedRateOverride(double v);
	int GetDestination(int axis, double *d);
	CCoordMotion();
	virtual ~CCoordMotion();

	void SetAbort();
	void ClearAbort();
	bool GetAbort();

	int FlushSegments();
	int CheckForOKToFlushSegments();
	int WaitForSegmentsFinished(BOOL NoErrorOnDisable = FALSE);
	int WaitForMoveXYZAFinished();
	int DoKMotionCmd(const char *s);
	int DoKMotionBufCmd(const char *s);
	MOTION_PARAMS *GetMotionParams();
	void ConvertAbsoluteToInterpreterCoord(double x,double y,double z,double a, 
										double *gx,double *gy,double *gz,double *ga);
	void ConvertAbsoluteToMachine(double x,double y,double z,double a, 
									double *gx,double *gy,double *gz,double *ga);
	int MeasurePointAppendToFile(const char *name);
	int StraightTraverse(double x, double y, double z, double a);
	int ArcFeed(double DesiredFeedRate_in_per_sec, 
				double first_end, double second_end, 
		        double first_axis, double second_axis, int rotation,
				double axis_end_point);

	int StraightFeed(double DesiredFeedRate_in_per_sec,
				     double x, double y, double z, double a);

	int CCoordMotion::Dwell(double seconds);

	int ReadAndSyncCurPositions();
	int ReadCurAbsPosition(double *x, double *y, double *z, double *a);

	void SetStraightTraverseCallback(STRAIGHT_TRAVERSE_CALLBACK *p);
	void SetStraightFeedCallback(STRAIGHT_FEED_CALLBACK *p);
	void SetArcFeedCallback(ARC_FEED_CALLBACK *p);
	int DownloadDoneSegments();
	int OutputSegment(int iseg);
	int DoSpecialCommand(int iseg);
	
	CKMotionDLL KMotionDLL;

	double m_TotalDownloadedTime;
	int m_nsegs_downloaded;
	double m_TimeAlreadyExecuted;


	char MainPath[MAX_PATH],MainPathRoot[MAX_PATH];

	int m_board;

	bool m_Simulate;

	bool m_AxisDisabled;

	int GetAxisDefinitions(int *x, int *y, int *z, int *a);
	bool m_DefineCS_valid;
	int x_axis,y_axis,z_axis,a_axis;  // map board channel number to interperter axis 

	double current_x, current_y, current_z, current_a;
private:
	bool m_Abort;
	double m_FeedRateOverride;
	STRAIGHT_TRAVERSE_CALLBACK *m_StraightTraverseCallback;
	STRAIGHT_FEED_CALLBACK *m_StraightFeedCallback;
	ARC_FEED_CALLBACK *m_ArcFeedCallback;
	bool m_SegmentsStartedExecuting;
};

#endif // !defined(AFX_COORDMOTION_H__36110031_9633_4D82_9C05_E1FDEC3AC8EA__INCLUDED_)
